/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CheckTagEmptyBodyInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (tag instanceof HtmlTag) {
                    return;
                }
                ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
                if (child == null) {
                    return;
                }
                ASTNode node = child.getTreeNext();
                if (node != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    holder.registerProblem((PsiElement)tag, XmlAnalysisBundle.message("xml.inspections.tag.empty.body", new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)(CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? new CollapseTagIntention() : null)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/CheckTagEmptyBodyInspection$1", "visitXmlTag"));
            }
        };
    }

    static boolean isCollapsibleTag(XmlTag tag) {
        String name = StringUtil.toLowerCase((String)tag.getName());
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name) || XmlExtension.isCollapsible(tag);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckTagEmptyBody";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/CheckTagEmptyBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/CheckTagEmptyBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

