/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructPermittedSubclassesAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructRecordAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructClass
extends StructMember {
    public final String qualifiedName;
    public final PrimitiveConstant superClass;
    private final boolean own;
    private final LazyLoader loader;
    private final int minorVersion;
    private final int majorVersion;
    private final int[] interfaces;
    private final String[] interfaceNames;
    private final VBStyleCollection<StructField, String> fields;
    private final VBStyleCollection<StructMethod, String> methods;
    private final GenericClassDescriptor signature;
    private ConstantPool pool;
    private Map<String, Map<VarType, VarType>> genericHierarchy;

    public static StructClass create(DataInputFullStream in, boolean own, LazyLoader loader) throws IOException {
        StructGenericSignatureAttribute signatureAttr;
        in.discard(4);
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        int bytecodeVersion = Math.max(majorVersion, 48);
        ConstantPool pool = new ConstantPool(in);
        int accessFlags = in.readUnsignedShort();
        int thisClassIdx = in.readUnsignedShort();
        int superClassIdx = in.readUnsignedShort();
        String qualifiedName = pool.getPrimitiveConstant(thisClassIdx).getString();
        PrimitiveConstant superClass = pool.getPrimitiveConstant(superClassIdx);
        int length = in.readUnsignedShort();
        int[] interfaces = new int[length];
        String[] interfaceNames = new String[length];
        for (int i = 0; i < length; ++i) {
            interfaces[i] = in.readUnsignedShort();
            interfaceNames[i] = pool.getPrimitiveConstant(interfaces[i]).getString();
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructField, String> fields = new VBStyleCollection<StructField, String>(length);
        for (int i = 0; i < length; ++i) {
            StructField field = StructField.create(in, pool, qualifiedName);
            fields.addWithKey(field, InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor()));
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructMethod, String> methods = new VBStyleCollection<StructMethod, String>(length);
        for (int i = 0; i < length; ++i) {
            StructMethod method = StructMethod.create(in, pool, qualifiedName, bytecodeVersion, own);
            methods.addWithKey(method, InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor()));
        }
        Map<String, StructGeneralAttribute> attributes = StructClass.readAttributes(in, pool);
        GenericClassDescriptor signature = null;
        if (DecompilerContext.getOption("dgs") && (signatureAttr = (StructGenericSignatureAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name)) != null) {
            signature = GenericMain.parseClassSignature(qualifiedName, signatureAttr.getSignature());
        }
        StructClass cl = new StructClass(accessFlags, attributes, qualifiedName, superClass, own, loader, minorVersion, majorVersion, interfaces, interfaceNames, fields, methods, signature);
        if (loader == null) {
            cl.pool = pool;
        }
        return cl;
    }

    private StructClass(int accessFlags, Map<String, StructGeneralAttribute> attributes, String qualifiedName, PrimitiveConstant superClass, boolean own, LazyLoader loader, int minorVersion, int majorVersion, int[] interfaces, String[] interfaceNames, VBStyleCollection<StructField, String> fields, VBStyleCollection<StructMethod, String> methods, GenericClassDescriptor signature) {
        super(accessFlags, attributes);
        this.qualifiedName = qualifiedName;
        this.superClass = superClass;
        this.own = own;
        this.loader = loader;
        this.minorVersion = minorVersion;
        this.majorVersion = majorVersion;
        this.interfaces = interfaces;
        this.interfaceNames = interfaceNames;
        this.fields = fields;
        this.methods = methods;
        this.signature = signature;
    }

    public boolean hasField(String name, String descriptor) {
        return this.getField(name, descriptor) != null;
    }

    public StructField getField(String name, String descriptor) {
        return this.fields.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethod(String key) {
        return this.methods.getWithKey(key);
    }

    public StructMethod getMethod(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public String getInterface(int i) {
        return this.interfaceNames[i];
    }

    public void releaseResources() {
        if (this.loader != null) {
            this.pool = null;
        }
    }

    public ConstantPool getPool() {
        if (this.pool == null && this.loader != null) {
            this.pool = this.loader.loadPool(this.qualifiedName);
        }
        return this.pool;
    }

    public List<StructRecordComponent> getRecordComponents() {
        StructRecordAttribute recordAttr = this.getAttribute(StructGeneralAttribute.ATTRIBUTE_RECORD);
        if (recordAttr == null) {
            return null;
        }
        return recordAttr.getComponents();
    }

    public List<String> getPermittedSubclasses() {
        StructPermittedSubclassesAttribute permittedSubClassAttr = this.getAttribute(StructGeneralAttribute.ATTRIBUTE_PERMITTED_SUBCLASSES);
        if (permittedSubClassAttr == null) {
            return null;
        }
        return permittedSubClassAttr.getClasses();
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public VBStyleCollection<StructMethod, String> getMethods() {
        return this.methods;
    }

    public VBStyleCollection<StructField, String> getFields() {
        return this.fields;
    }

    public boolean isOwn() {
        return this.own;
    }

    public LazyLoader getLoader() {
        return this.loader;
    }

    public boolean isVersion5() {
        return this.majorVersion > 48 || this.majorVersion == 48 && this.minorVersion > 0;
    }

    public boolean isVersion7() {
        return this.majorVersion >= 51;
    }

    public boolean isVersion8() {
        return this.majorVersion >= 52;
    }

    public boolean isVersion9() {
        return this.majorVersion >= 53;
    }

    public boolean isVersion14() {
        return this.majorVersion >= 58;
    }

    public boolean isVersion15() {
        return this.majorVersion >= 59;
    }

    public boolean isVersion16() {
        return this.majorVersion >= 60;
    }

    public boolean isVersion17() {
        return this.majorVersion >= 61;
    }

    public boolean isVersion21() {
        return this.majorVersion >= 65;
    }

    public boolean isPreviewVersion() {
        return this.minorVersion == 65535;
    }

    public boolean hasSealedClassesSupport() {
        return this.isVersion17() || this.isVersion15() && this.isPreviewVersion();
    }

    public boolean hasPatternsInInstanceofSupport() {
        return this.isVersion16() || this.isVersion14() && this.isPreviewVersion();
    }

    public boolean hasEnhancedSwitchSupport() {
        return this.isVersion14();
    }

    public boolean hasRecordPatternSupport() {
        return this.isVersion21();
    }

    public String toString() {
        return this.qualifiedName;
    }

    @Override
    protected Type getType() {
        return null;
    }

    public GenericClassDescriptor getSignature() {
        return this.signature;
    }

    private Map<VarType, VarType> getGenericMap(VarType type) {
        if (this.signature == null || type == null || !type.isGeneric()) {
            return Collections.emptyMap();
        }
        GenericType gtype = (GenericType)type;
        if (gtype.getArguments().size() != this.signature.fparameters.size()) {
            return Collections.emptyMap();
        }
        HashMap<VarType, VarType> ret = new HashMap<VarType, VarType>();
        for (int x = 0; x < this.signature.fparameters.size(); ++x) {
            VarType var = gtype.getArguments().get(x);
            if (var == null) continue;
            ret.put(GenericType.parse("T" + this.signature.fparameters.get(x) + ";"), var);
        }
        return ret;
    }

    public Map<String, Map<VarType, VarType>> getAllGenerics() {
        StructClass cls;
        if (this.genericHierarchy != null) {
            return this.genericHierarchy;
        }
        HashMap<String, Map<Object, Object>> ret = new HashMap<String, Map<Object, Object>>();
        if (this.signature != null && !this.signature.fparameters.isEmpty()) {
            HashMap<VarType, VarType> mine = new HashMap<VarType, VarType>();
            for (String par : this.signature.fparameters) {
                VarType type = GenericType.parse("T" + par + ";");
                mine.put(type, type);
            }
            ret.put(this.qualifiedName, mine);
        }
        HashSet<String> visited = new HashSet<String>();
        if (this.signature != null) {
            for (VarType intf : this.signature.superinterfaces) {
                visited.add(intf.getValue());
                StructClass cls2 = DecompilerContext.getStructContext().getClass(intf.getValue());
                if (cls2 == null) continue;
                Map<VarType, VarType> sig = cls2.getGenericMap(intf);
                for (Map.Entry<String, Map<VarType, VarType>> e : cls2.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        for (String intf : this.interfaceNames) {
            StructClass cls3;
            if (visited.contains(intf) || (cls3 = DecompilerContext.getStructContext().getClass(intf)) == null) continue;
            ret.putAll(cls3.getAllGenerics());
        }
        if (this.superClass != null && (cls = DecompilerContext.getStructContext().getClass((String)this.superClass.value)) != null) {
            Map sig;
            Map<Object, VarType> map = sig = this.signature == null ? Collections.emptyMap() : cls.getGenericMap(this.signature.superclass);
            if (sig.isEmpty()) {
                ret.putAll(cls.getAllGenerics());
            } else {
                for (Map.Entry<String, Map<VarType, VarType>> e : cls.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        this.genericHierarchy = ret.isEmpty() ? Collections.emptyMap() : ret;
        return this.genericHierarchy;
    }
}

