/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label, Object value) {
        this.contextValues.add(new ImmutablePair<String, Object>(label, value));
        return this;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public Set<String> getContextLabels() {
        return this.stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    @Override
    public List<Object> getContextValues(String label) {
        return this.stream().filter(pair -> Strings.CS.equals(label, (String)pair.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    @Override
    public Object getFirstContextValue(String label) {
        return this.stream().filter(pair -> Strings.CS.equals(label, (String)pair.getKey())).findFirst().map(Pair::getValue).orElse(null);
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer2 = new StringBuilder(256);
        if (baseMessage != null) {
            buffer2.append(baseMessage);
        }
        if (!this.contextValues.isEmpty()) {
            if (buffer2.length() > 0) {
                buffer2.append('\n');
            }
            buffer2.append("Exception Context:\n");
            int i = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                buffer2.append("\t[");
                buffer2.append(++i);
                buffer2.append(':');
                buffer2.append(pair.getKey());
                buffer2.append("=");
                Object value = pair.getValue();
                try {
                    buffer2.append(Objects.toString(value));
                }
                catch (Exception e2) {
                    buffer2.append("Exception thrown on toString(): ");
                    buffer2.append(ExceptionUtils.getStackTrace(e2));
                }
                buffer2.append("]\n");
            }
            buffer2.append("---------------------------------");
        }
        return buffer2.toString();
    }

    @Override
    public DefaultExceptionContext setContextValue(String label, Object value) {
        this.contextValues.removeIf(p -> Strings.CS.equals(label, (String)p.getKey()));
        this.addContextValue(label, value);
        return this;
    }

    private Stream<Pair<String, Object>> stream() {
        return this.contextValues.stream();
    }
}

