/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

final class ServiceLoaderLine
implements Comparable<ServiceLoaderLine> {
    private static final String POSITION = "#position=";
    private static final String SUPERSEDE = "#-";
    private final String impl;
    private final int position;
    private final String[] supersedes;

    public ServiceLoaderLine(String string, int n, String[] stringArray) {
        this.impl = string;
        this.position = n;
        this.supersedes = stringArray;
    }

    @Override
    public int compareTo(ServiceLoaderLine serviceLoaderLine) {
        if (this.impl.equals(serviceLoaderLine.impl)) {
            return 0;
        }
        int n = this.position - serviceLoaderLine.position;
        return n != 0 ? n : this.impl.compareTo(serviceLoaderLine.impl);
    }

    public boolean equals(Object object) {
        return object instanceof ServiceLoaderLine && this.impl.equals(((ServiceLoaderLine)object).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public void write(PrintWriter printWriter) {
        printWriter.println(this.impl);
        if (this.position != Integer.MAX_VALUE) {
            printWriter.println(POSITION + this.position);
        }
        for (String string : this.supersedes) {
            printWriter.println(SUPERSEDE + string);
        }
    }

    public static void parse(Reader reader, SortedSet<ServiceLoaderLine> sortedSet) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = null;
        int n = Integer.MAX_VALUE;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith(POSITION)) {
                n = Integer.parseInt(string.substring(POSITION.length()));
                continue;
            }
            if (string.startsWith(SUPERSEDE)) {
                arrayList.add(string.substring(SUPERSEDE.length()));
                continue;
            }
            ServiceLoaderLine.finalize(sortedSet, string2, n, arrayList);
            string2 = string;
            n = Integer.MAX_VALUE;
            arrayList.clear();
        }
        ServiceLoaderLine.finalize(sortedSet, string2, n, arrayList);
    }

    private static void finalize(Set<ServiceLoaderLine> set, String string, int n, List<String> list) {
        if (string != null) {
            set.add(new ServiceLoaderLine(string, n, list.toArray(new String[0])));
        }
    }
}

