/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.jaxws.JAXWSServiceFactory;
import org.codehaus.xfire.jaxws.binding.AbstractBinding;
import org.codehaus.xfire.jaxws.binding.HTTPBinding;
import org.codehaus.xfire.jaxws.binding.SOAPBinding;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;

public class JAXWSHelper {
    private XFire xfire = XFireFactory.newInstance().getXFire();
    private TransportManager tManager = this.xfire.getTransportManager();
    private ServiceFactory serviceFactory = new JAXWSServiceFactory(this.tManager);
    private XFireProxyFactory proxyFactory = new XFireProxyFactory(this.xfire);
    private Map<String, AbstractBinding> bindings = new HashMap<String, AbstractBinding>();
    private Map<Transport, AbstractBinding> transport2Binding = new HashMap<Transport, AbstractBinding>();
    private static JAXWSHelper helper = new JAXWSHelper();
    private Service sourceService;

    protected JAXWSHelper() {
        this.createSoapBinding("http://schemas.xmlsoap.org/soap/http", "http://schemas.xmlsoap.org/wsdl/soap/http");
        this.createSoapBinding("http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        this.createSoapBinding("urn:xfire:transport:local", "urn:xfire:transport:local");
        Transport http = this.tManager.getTransport("http://www.w3.org/2004/08/wsdl/http");
        HTTPBinding binding = new HTTPBinding(http);
        this.bindings.put("http://www.w3.org/2004/08/wsdl/http", binding);
        this.transport2Binding.put(http, binding);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.createDefaultBindings", Boolean.TRUE);
        props.put("objectServiceFactory.style", "document");
        this.sourceService = new ObjectServiceFactory().create(SourceService.class, props);
    }

    public void createSoapBinding(String id, String jaxId) {
        Transport localSoap = this.tManager.getTransport(id);
        SOAPBinding binding = new SOAPBinding(localSoap);
        this.bindings.put(jaxId, binding);
        this.transport2Binding.put(localSoap, binding);
    }

    public static JAXWSHelper getInstance() {
        return helper;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public TransportManager getTransportManager() {
        return this.xfire.getTransportManager();
    }

    public XFireProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public AbstractBinding getBinding(String bindingUri) {
        return this.bindings.get(bindingUri);
    }

    public AbstractBinding getBinding(Transport t) {
        return this.transport2Binding.get(t);
    }

    public Service getSourceService() {
        return this.sourceService;
    }

    public static interface SourceService {
        public Source invoke(Source var1);
    }
}

