/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.building;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.building.Problem;

public class ToolchainsBuildingException
extends Exception {
    private final List<Problem> problems = new ArrayList<Problem>();

    public ToolchainsBuildingException(List<Problem> problems) {
        super(ToolchainsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<Problem> problems) {
        StringWriter buffer2 = new StringWriter(1024);
        PrintWriter writer2 = new PrintWriter(buffer2);
        writer2.print(problems.size());
        writer2.print(problems.size() == 1 ? " problem was " : " problems were ");
        writer2.print("encountered while building the effective toolchains");
        writer2.println();
        for (Problem problem : problems) {
            writer2.print("[");
            writer2.print((Object)problem.getSeverity());
            writer2.print("] ");
            writer2.print(problem.getMessage());
            String location = problem.getLocation();
            if (!location.isEmpty()) {
                writer2.print(" @ ");
                writer2.print(location);
            }
            writer2.println();
        }
        return buffer2.toString();
    }
}

