untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSElkcC4KxZdBMACp4sx4KaavtI4xzKaC8KOqz98MCBi0MqIDNEWphXF9dFi/qDub3/eXcyM3S9f3HqjuD9I+DHQM=

OpenBSD 6.1 errata 10, June 04, 2017:

Use fchmod to avoid a race condition in File::Path.  
Fixes CVE-2017-6512.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 010_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then install the new file:
    install -o root -g wheel -m 0444 \
        /usr/src/gnu/usr.bin/perl/cpan/File-Path/lib/File/Path.pm \
        /usr/libdata/perl5/File/

Index: gnu/usr.bin/perl/cpan/File-Path/lib/File/Path.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/File-Path/lib/File/Path.pm,v
retrieving revision 1.2
diff -u -p -u -p -r1.2 Path.pm
--- gnu/usr.bin/perl/cpan/File-Path/lib/File/Path.pm	5 Feb 2017 00:31:58 -0000	1.2
+++ gnu/usr.bin/perl/cpan/File-Path/lib/File/Path.pm	1 Jun 2017 22:00:11 -0000
@@ -18,7 +18,7 @@ BEGIN {
 
 use Exporter ();
 use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
-$VERSION   = '2.12_01';
+$VERSION   = '2.12_02';
 $VERSION   = eval $VERSION;
 @ISA       = qw(Exporter);
 @EXPORT    = qw(mkpath rmtree);
@@ -354,21 +354,32 @@ sub _rmtree {
 
                 # see if we can escalate privileges to get in
                 # (e.g. funny protection mask such as -w- instead of rwx)
-                $perm &= oct '7777';
-                my $nperm = $perm | oct '700';
-                if (
-                    !(
-                           $arg->{safe}
-                        or $nperm == $perm
-                        or chmod( $nperm, $root )
-                    )
-                  )
-                {
-                    _error( $arg,
-                        "cannot make child directory read-write-exec", $canon );
-                    next ROOT_DIR;
+                # This uses fchmod to avoid traversing outside of the proper
+                # location (CVE-2017-6512)
+                my $root_fh;
+                if (open($root_fh, '<', $root)) {
+                    my ($fh_dev, $fh_inode) = (stat $root_fh )[0,1];
+                    $perm &= oct '7777';
+                    my $nperm = $perm | oct '700';
+                    local $@;
+                    if (
+                        !(
+                            $arg->{safe}
+                           or $nperm == $perm
+                           or !-d _
+                           or $fh_dev ne $ldev
+                           or $fh_inode ne $lino
+                           or eval { chmod( $nperm, $root_fh ) }
+                        )
+                      )
+                    {
+                        _error( $arg,
+                            "cannot make child directory read-write-exec", $canon );
+                        next ROOT_DIR;
+                    }
+                    close $root_fh;
                 }
-                elsif ( !chdir($root) ) {
+                if ( !chdir($root) ) {
                     _error( $arg, "cannot chdir to child", $canon );
                     next ROOT_DIR;
                 }
