/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.IntSequence;
import gnu.lists.IntVector;

public class S32Vector
extends IntVector<Integer>
implements IntSequence {
    public S32Vector() {
        this.data = empty;
    }

    public S32Vector(int size, int value) {
        int[] array = new int[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public S32Vector(int size) {
        this(new int[size]);
    }

    public S32Vector(int[] data) {
        this.data = data;
    }

    public S32Vector(int[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final long getLongRaw(int index) {
        return this.data[index];
    }

    @Override
    public final Integer get(int index) {
        return this.data[this.effectiveIndex(index)];
    }

    @Override
    public final Integer getRaw(int index) {
        return this.data[index];
    }

    @Override
    public final void setRaw(int index, Integer value) {
        this.data[index] = value;
    }

    @Override
    protected S32Vector newInstance(int newLength) {
        return new S32Vector(newLength < 0 ? this.data : new int[newLength]);
    }

    public static S32Vector castOrNull(Object obj) {
        if (obj instanceof int[]) {
            return new S32Vector((int[])obj);
        }
        if (obj instanceof S32Vector) {
            return (S32Vector)obj;
        }
        return null;
    }

    public static S32Vector cast(Object value) {
        S32Vector vec = S32Vector.castOrNull(value);
        if (vec == null) {
            String msg = value == null ? "cannot convert null to S32Vector" : "cannot convert a " + value.getClass().getName() + " to S32Vector";
            throw new ClassCastException(msg);
        }
        return vec;
    }

    @Override
    public int getElementKind() {
        return 22;
    }

    @Override
    public String getTag() {
        return "s32";
    }

    public int compareTo(Object obj) {
        return S32Vector.compareToInt(this, (S32Vector)obj);
    }
}

