/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class FileCollectionBackedFileTree
extends AbstractFileTree {
    private final AbstractFileCollection collection;

    public FileCollectionBackedFileTree(TaskDependencyFactory taskDependencyFactory, PatternSetFactory patternSetFactory, AbstractFileCollection collection) {
        super(taskDependencyFactory, patternSetFactory);
        this.collection = collection;
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("backing collection");
        formatter.startChildren();
        this.collection.describeContents(formatter);
        formatter.endChildren();
    }

    public AbstractFileCollection getCollection() {
        return this.collection;
    }

    @Override
    public FileTreeInternal matching(PatternFilterable patterns) {
        return new FilteredFileTree(this, this.taskDependencyFactory, this.patternSetFactory, () -> {
            PatternSet patternSet = this.patternSetFactory.createPatternSet();
            patternSet.copyFrom(patterns);
            return patternSet;
        });
    }

    public FileTree visit(FileVisitor visitor) {
        this.visitContentsAsFileTrees(child -> child.visit(visitor));
        return this;
    }

    @Override
    public void visitContentsAsFileTrees(final Consumer<FileTreeInternal> visitor) {
        this.visitContents(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                throw new UnsupportedOperationException("Should not be called");
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                visitor.accept(fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                visitor.accept(fileTree);
            }
        });
    }

    @Override
    protected void visitContents(final FileCollectionStructureVisitor visitor) {
        this.collection.visitStructure(new FileCollectionStructureVisitor(){
            final Set<File> seen = new HashSet<File>();

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                PatternSet patterns = FileCollectionBackedFileTree.this.patternSetFactory.createPatternSet();
                for (File file : contents) {
                    if (!this.seen.add(file)) continue;
                    new FileTreeAdapter(new DirectoryFileTree(file, patterns, FileSystems.getDefault()), FileCollectionBackedFileTree.this.taskDependencyFactory, FileCollectionBackedFileTree.this.patternSetFactory).visitStructure(visitor);
                }
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                visitor.visitFileTree(root, patterns, fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                visitor.visitFileTreeBackedByFile(file, fileTree, sourceTree);
            }
        });
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.collection);
    }

    @Override
    public String getDisplayName() {
        return this.collection.getDisplayName();
    }
}

