/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.TableContext;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableContext
extends SqlAbstractTable
implements TableContext {
    private static final String TABLE_NAME = DbSQL.getSQL("context.table_name");
    private static final String DATAID = DbSQL.getSQL("context.field.dataid");
    private static final String CONTEXTID = DbSQL.getSQL("context.field.contextid");
    private static final String TYPE = DbSQL.getSQL("context.field.type");
    private static final String DATA = DbSQL.getSQL("context.field.data");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("context.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordContext read(long dataId) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordContext recordContext;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("context.ps.read");
                psRead.getPs().setLong(1, dataId);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordContext = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordContext;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public synchronized RecordContext insert(int contextId, int type, String url) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            long id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("context.ps.insert");
            psInsert.getPs().setInt(1, contextId);
            psInsert.getPs().setInt(2, type);
            psInsert.getPs().setString(3, url);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getLong(1);
            }
            RecordContext recordContext = this.read(id);
            return recordContext;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public synchronized void delete(int contextId, int type, String data) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteData = null;
        try {
            psDeleteData = DbSQL.getSingleton().getPreparedStatement("context.ps.delete");
            psDeleteData.getPs().setInt(1, contextId);
            psDeleteData.getPs().setInt(2, type);
            psDeleteData.getPs().setString(3, data);
            psDeleteData.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteData);
        }
    }

    @Override
    public synchronized void deleteAllDataForContextAndType(int contextId, int type) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteAllDataForContextAndType = null;
        try {
            psDeleteAllDataForContextAndType = DbSQL.getSingleton().getPreparedStatement("context.ps.deletealldataforcontexttype");
            psDeleteAllDataForContextAndType.getPs().setInt(1, contextId);
            psDeleteAllDataForContextAndType.getPs().setInt(2, type);
            psDeleteAllDataForContextAndType.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteAllDataForContextAndType);
        }
    }

    @Override
    public synchronized void deleteAllDataForContext(int contextId) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteAllDataForContext = null;
        try {
            psDeleteAllDataForContext = DbSQL.getSingleton().getPreparedStatement("context.ps.deletealldataforcontext");
            psDeleteAllDataForContext.getPs().setInt(1, contextId);
            psDeleteAllDataForContext.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteAllDataForContext);
        }
    }

    @Override
    public List<RecordContext> getAllData() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllData = null;
        try {
            psGetAllData = DbSQL.getSingleton().getPreparedStatement("context.ps.alldata");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            try (ResultSet rs = psGetAllData.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllData);
        }
    }

    @Override
    public List<RecordContext> getDataForContext(int contextId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllDataForContext = null;
        try {
            psGetAllDataForContext = DbSQL.getSingleton().getPreparedStatement("context.ps.alldataforcontext");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            psGetAllDataForContext.getPs().setInt(1, contextId);
            try (ResultSet rs = psGetAllDataForContext.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllDataForContext);
        }
    }

    @Override
    public List<RecordContext> getDataForContextAndType(int contextId, int type) throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllDataForContextAndType = null;
        try {
            psGetAllDataForContextAndType = DbSQL.getSingleton().getPreparedStatement("context.ps.alldataforcontexttype");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            psGetAllDataForContextAndType.getPs().setInt(1, contextId);
            psGetAllDataForContextAndType.getPs().setInt(2, type);
            try (ResultSet rs = psGetAllDataForContextAndType.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllDataForContextAndType);
        }
    }

    private RecordContext build(ResultSet rs) throws DatabaseException {
        try {
            RecordContext rt = null;
            if (rs.next()) {
                rt = new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setData(int contextId, int type, List<String> dataList) throws DatabaseException {
        this.deleteAllDataForContextAndType(contextId, type);
        for (String data : dataList) {
            this.insert(contextId, type, data);
        }
    }
}

