package MyTypes::BarCodeData;
use strict;
use warnings;
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Height_of :ATTR(:get<Height>);
my %Width_of :ATTR(:get<Width>);
my %Angle_of :ATTR(:get<Angle>);
my %Ratio_of :ATTR(:get<Ratio>);
my %Module_of :ATTR(:get<Module>);
my %Left_of :ATTR(:get<Left>);
my %Top_of :ATTR(:get<Top>);
my %CheckSum_of :ATTR(:get<CheckSum>);
my %FontName_of :ATTR(:get<FontName>);
my %BarColor_of :ATTR(:get<BarColor>);
my %BGColor_of :ATTR(:get<BGColor>);
my %FontSize_of :ATTR(:get<FontSize>);
my %barcodeOption_of :ATTR(:get<barcodeOption>);
my %barcodeType_of :ATTR(:get<barcodeType>);
my %checkSumMethod_of :ATTR(:get<checkSumMethod>);
my %showTextPosition_of :ATTR(:get<showTextPosition>);
my %BarCodeImageFormat_of :ATTR(:get<BarCodeImageFormat>);

__PACKAGE__->_factory(
    [ qw(
        Height
        Width
        Angle
        Ratio
        Module
        Left
        Top
        CheckSum
        FontName
        BarColor
        BGColor
        FontSize
        barcodeOption
        barcodeType
        checkSumMethod
        showTextPosition
        BarCodeImageFormat
    ) ],
    {
        Height => \%Height_of,
        Width => \%Width_of,
        Angle => \%Angle_of,
        Ratio => \%Ratio_of,
        Module => \%Module_of,
        Left => \%Left_of,
        Top => \%Top_of,
        CheckSum => \%CheckSum_of,
        FontName => \%FontName_of,
        BarColor => \%BarColor_of,
        BGColor => \%BGColor_of,
        FontSize => \%FontSize_of,
        barcodeOption => \%barcodeOption_of,
        barcodeType => \%barcodeType_of,
        checkSumMethod => \%checkSumMethod_of,
        showTextPosition => \%showTextPosition_of,
        BarCodeImageFormat => \%BarCodeImageFormat_of,
    },
    {
        Height => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Width => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Angle => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Ratio => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Module => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Left => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Top => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        CheckSum => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        FontName => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        BarColor => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        BGColor => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        FontSize => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        barcodeOption => 'MyTypes::BarcodeOption',
        barcodeType => 'MyTypes::BarcodeType',
        checkSumMethod => 'MyTypes::CheckSumMethod',
        showTextPosition => 'MyTypes::ShowTextPosition',
        BarCodeImageFormat => 'MyTypes::ImageFormats',
    }
);

} # end BLOCK






1;

=pod

=head1 NAME

MyTypes::BarCodeData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complextype
BarCodeData from the namespace http://www.webservicex.net/.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

 Height
 Width
 Angle
 Ratio
 Module
 Left
 Top
 CheckSum
 FontName
 BarColor
 BGColor
 FontSize
 barcodeOption
 barcodeType
 checkSumMethod
 showTextPosition
 BarCodeImageFormat


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::BarCodeData
   Height =>  $some_value, # int
   Width =>  $some_value, # int
   Angle =>  $some_value, # int
   Ratio =>  $some_value, # int
   Module =>  $some_value, # int
   Left =>  $some_value, # int
   Top =>  $some_value, # int
   CheckSum =>  $some_value, # boolean
   FontName =>  $some_value, # string
   BarColor =>  $some_value, # string
   BGColor =>  $some_value, # string
   FontSize =>  $some_value, # float
   barcodeOption => $some_value, # BarcodeOption
   barcodeType => $some_value, # BarcodeType
   checkSumMethod => $some_value, # CheckSumMethod
   showTextPosition => $some_value, # ShowTextPosition
   BarCodeImageFormat => $some_value, # ImageFormats
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

