/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;
import org.apache.mina.integration.beans.PropertyEditorFactory;

public class MapEditor
extends AbstractPropertyEditor {
    static final Pattern ELEMENT = Pattern.compile("([,\\s]+)|(\\s*=\\s*)|(?<=\")((?:\\\\\"|\\\\'|\\\\\\\\|\\\\ |[^\"])*)(?=\")|(?<=')((?:\\\\\"|\\\\'|\\\\\\\\|\\\\ |[^'])*)(?=')|((?:[^\\\\\\s'\",]|\\\\ |\\\\\"|\\\\')+)");
    private final Class<?> keyType;
    private final Class<?> valueType;
    private static final String NO_VALUE = "No value {1} found for {2}.";
    private static final String NO_KEY = "No key {1} found for {2}.";

    public MapEditor(Class<?> keyType, Class<?> valueType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType");
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.getKeyEditor();
        this.getValueEditor();
        this.setTrimText(false);
    }

    private PropertyEditor getKeyEditor() {
        PropertyEditor e = PropertyEditorFactory.getInstance(this.keyType);
        if (e == null) {
            throw new IllegalArgumentException(MessageFormat.format(NO_KEY, PropertyEditor.class.getSimpleName(), this.keyType.getSimpleName()));
        }
        return e;
    }

    private PropertyEditor getValueEditor() {
        PropertyEditor e = PropertyEditorFactory.getInstance(this.valueType);
        if (e == null) {
            throw new IllegalArgumentException(MessageFormat.format(NO_VALUE, PropertyEditor.class.getSimpleName(), this.valueType.getSimpleName()));
        }
        return e;
    }

    @Override
    protected final String toText(Object value) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Object ekey = entry.getKey();
            Object evalue = entry.getValue();
            PropertyEditor ekeyEditor = PropertyEditorFactory.getInstance(ekey);
            if (ekeyEditor == null) {
                throw new IllegalArgumentException(MessageFormat.format(NO_KEY, PropertyEditor.class.getSimpleName(), ekey.getClass().getSimpleName()));
            }
            ekeyEditor.setValue(ekey);
            PropertyEditor evalueEditor = PropertyEditorFactory.getInstance(evalue);
            if (evalueEditor == null) {
                throw new IllegalArgumentException(MessageFormat.format(NO_VALUE, PropertyEditor.class.getSimpleName(), evalue.getClass().getSimpleName()));
            }
            ekeyEditor.setValue(ekey);
            evalueEditor.setValue(evalue);
            String keyString = ekeyEditor.getAsText();
            String valueString = evalueEditor.getAsText();
            buf.append(keyString);
            buf.append(" = ");
            buf.append(valueString);
            buf.append(", ");
        }
        if (buf.length() >= 2) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    @Override
    protected final Object toValue(String text) {
        PropertyEditor keyEditor = this.getKeyEditor();
        PropertyEditor valueEditor = this.getValueEditor();
        Map<Object, Object> answer = this.newMap();
        Matcher m = ELEMENT.matcher(text);
        TokenType lastTokenType = TokenType.ENTRY_DELIM;
        Object key = null;
        while (m.find()) {
            if (m.group(1) != null) {
                if (lastTokenType != TokenType.VALUE && lastTokenType != TokenType.ENTRY_DELIM) {
                    throw new IllegalArgumentException("Unexpected entry delimiter: " + text);
                }
                lastTokenType = TokenType.ENTRY_DELIM;
                continue;
            }
            if (m.group(2) != null) {
                if (lastTokenType != TokenType.KEY) {
                    throw new IllegalArgumentException("Unexpected key-value delimiter: " + text);
                }
                lastTokenType = TokenType.KEY_VALUE_DELIM;
                continue;
            }
            String region = m.group();
            if (m.group(3) != null || m.group(4) != null) {
                m.region(m.end() + 1, m.regionEnd());
            }
            switch (lastTokenType) {
                case ENTRY_DELIM: {
                    keyEditor.setAsText(region);
                    key = keyEditor.getValue();
                    lastTokenType = TokenType.KEY;
                    break;
                }
                case KEY_VALUE_DELIM: {
                    valueEditor.setAsText(region);
                    Object value = valueEditor.getValue();
                    lastTokenType = TokenType.VALUE;
                    answer.put(key, value);
                    break;
                }
                case KEY: 
                case VALUE: {
                    throw new IllegalArgumentException("Unexpected key or value: " + text);
                }
            }
        }
        return answer;
    }

    protected Map<Object, Object> newMap() {
        return new LinkedHashMap<Object, Object>();
    }

    private static enum TokenType {
        ENTRY_DELIM,
        KEY_VALUE_DELIM,
        KEY,
        VALUE;

    }
}

