/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.List;

public class OPSChecker
extends PublicationResourceChecker {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().putAll((Predicate<? super ValidationContext>)Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.XHTML_20_NVDL, XMLValidators.XHTML_20_SCH, XMLValidators.IDUNIQUE_20_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_30_NVDL, XMLValidators.SVG_30_INFORMATIVE_NVDL).putAll((Predicate<? super ValidationContext>)Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("image/svg+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.SVG_20_NVDL, XMLValidators.IDUNIQUE_20_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("image/svg+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.SVG_30_NVDL, XMLValidators.SVG_30_INFORMATIVE_NVDL).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.DICTIONARY)), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)}), XMLValidators.XHTML_DICT_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.EDUPUB)), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT))), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR))), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)}), XMLValidators.XHTML_EDUPUB_STRUCTURE_SCH, XMLValidators.XHTML_EDUPUB_SEMANTICS_SCH, XMLValidators.XHTML_IDX_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or((Predicate[])new Predicate[]{ValidationContext.ValidationContextPredicates.profile(EPUBProfile.IDX), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.INDEX), ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.INDEX)), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION))}), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)}), XMLValidators.XHTML_IDX_SCH, XMLValidators.XHTML_IDX_INDEX_SCH).put(ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV)), XMLValidators.XHTML_DATANAV_SCH).build();

    public OPSChecker(ValidationContext context) {
        super(context);
    }

    @Override
    protected boolean checkContent() {
        List<XMLValidator> validators = validatorMap.getValidators(this.context);
        try {
            this.validate(validators);
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.of(this.context), this.context.path);
        }
        return true;
    }

    void validate(List<XMLValidator> validators) throws IOException {
        XMLParser opsParser = new XMLParser(this.context);
        OPSHandler opsHandler = this.context.version == EPUBVersion.VERSION_2 ? new OPSHandler(this.context) : new OPSHandler30(this.context);
        opsParser.addContentHandler(opsHandler);
        for (XMLValidator validator : validators) {
            opsParser.addValidator(validator);
        }
        opsParser.process();
    }
}

