/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ContainerPaneUI;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.olap.BasicCubePaneUI;
import ca.sqlpower.architect.swingui.olap.CalculatedMemberEditPanel;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.architect.swingui.olap.DimensionEditPanel;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.MeasureEditPanel;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.OLAPPaneSection;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CubePane
extends OLAPPane<MondrianModel.Cube, OLAPObject> {
    private static final Logger logger = Logger.getLogger(CubePane.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;

    public CubePane(MondrianModel.Cube model) {
        super(model.getName());
        this.model = model;
        OLAPPaneSection<MondrianModel.CubeDimension> dimensionSection = new OLAPPaneSection<MondrianModel.CubeDimension>(MondrianModel.CubeDimension.class, model.getDimensions(), "Dimensions:"){

            @Override
            public void addItem(int idx, MondrianModel.CubeDimension item) {
                ((MondrianModel.Cube)((Object)CubePane.this.model)).addDimension(idx, item);
            }
        };
        OLAPPaneSection<MondrianModel.Measure> measureSection = new OLAPPaneSection<MondrianModel.Measure>(MondrianModel.Measure.class, model.getMeasures(), "Measures:"){

            @Override
            public void addItem(int idx, MondrianModel.Measure item) {
                ((MondrianModel.Cube)((Object)CubePane.this.model)).addMeasure(idx, item);
            }
        };
        OLAPPaneSection<MondrianModel.CalculatedMember> calculatedMemberSection = new OLAPPaneSection<MondrianModel.CalculatedMember>(MondrianModel.CalculatedMember.class, model.getCalculatedMembers(), "Calculated Members:"){

            @Override
            public void addItem(int idx, MondrianModel.CalculatedMember item) {
                ((MondrianModel.Cube)((Object)CubePane.this.model)).addCalculatedMember(idx, item);
            }
        };
        this.sections.add(dimensionSection);
        this.sections.add(measureSection);
        this.sections.add(calculatedMemberSection);
    }

    public CubePane(CubePane copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.updateUI();
    }

    @Constructor
    public CubePane(@ConstructorParameter(propertyName="model") MondrianModel.Cube model, @ConstructorParameter(propertyName="parent") PlayPenContentPane parent) {
        this(model);
        this.setParent((SPObject)parent);
        this.updateUI();
    }

    @Override
    @Transient
    @Accessor
    protected List<OLAPObject> getItems() {
        return ((MondrianModel.Cube)((Object)this.model)).getChildren(OLAPObject.class);
    }

    public void updateUI() {
        ContainerPaneUI ui = (ContainerPaneUI)BasicCubePaneUI.createUI();
        ui.installUI(this);
        this.setUI(ui);
    }

    public String toString() {
        return "CubePane: " + ((MondrianModel.Cube)((Object)this.model)).getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataEntryPanel createEditDialog(PlayPenCoordinate<MondrianModel.Cube, OLAPObject> coord) throws SQLObjectException {
        if (coord.getIndex() == -1) {
            return new CubeEditPanel((MondrianModel.Cube)((Object)this.model), this.getPlayPen(), this.getPlayPen().getSession());
        }
        if (coord.getIndex() == -3) {
            return null;
        }
        if (coord.getIndex() <= -1) return null;
        if (coord.getItem() instanceof MondrianModel.Dimension) {
            return new DimensionEditPanel((MondrianModel.Dimension)coord.getItem());
        }
        if (coord.getItem() instanceof MondrianModel.Measure) {
            return new MeasureEditPanel((MondrianModel.Measure)coord.getItem());
        }
        if (coord.getItem() instanceof MondrianModel.DimensionUsage) {
            UsageComponent usageComp = (UsageComponent)this.getPlayPen().findPPComponent((Object)coord.getItem());
            MondrianModel.Dimension dimension = (MondrianModel.Dimension)((Object)usageComp.getPane1().getModel());
            return new DimensionEditPanel(dimension);
        }
        if (!(coord.getItem() instanceof MondrianModel.CalculatedMember)) throw new IllegalArgumentException("Edit dialog for type " + ((Object)((Object)coord.getItem())).getClass() + " cannot be created!");
        return new CalculatedMemberEditPanel((MondrianModel.CalculatedMember)coord.getItem());
    }

    @Override
    protected List<OLAPObject> filterDroppableItems(List<OLAPObject> items) {
        ArrayList<OLAPObject> filtered = new ArrayList<OLAPObject>();
        for (OLAPObject item : items) {
            if (item instanceof MondrianModel.Measure || item instanceof MondrianModel.Dimension || item instanceof MondrianModel.DimensionUsage || item instanceof MondrianModel.CalculatedMember) {
                filtered.add(item);
                continue;
            }
            logger.debug((Object)(" Ignoring dropped item of type " + ((Object)((Object)item)).getClass().getName()));
        }
        return filtered;
    }

    @Override
    protected int dndRemoveAndAdd(PaneSection<OLAPObject> insertSection, int insertIndex, OLAPObject item) {
        OLAPObject newItem = item;
        if (item instanceof MondrianModel.DimensionUsage) {
            newItem = new MondrianModel.DimensionUsage((MondrianModel.DimensionUsage)item);
            MondrianModel.Dimension refDimension = OLAPUtil.findReferencedDimension((MondrianModel.DimensionUsage)item);
            PlayPenContentPane contentPane = this.getParent();
            DimensionPane dimensionPane = null;
            for (PlayPenComponent playPenComponent : contentPane.getChildren()) {
                if (playPenComponent.getModel() != refDimension) continue;
                dimensionPane = (DimensionPane)playPenComponent;
                break;
            }
            UsageComponent uc = new UsageComponent(contentPane, newItem, dimensionPane, this);
            contentPane.addChild((SPObject)uc, contentPane.getChildren().size());
        }
        logger.debug((Object)(" Dragging and dropping item of type " + ((Object)((Object)item)).getClass().getName()));
        try {
            if (insertSection != null && insertIndex >= 0 && insertSection.getItemType().isInstance((Object)item)) {
                item.getParent().removeChild((SPObject)item);
                insertSection.addItem(insertIndex++, newItem);
            } else {
                item.getParent().removeChild((SPObject)item);
                ((MondrianModel.Cube)((Object)this.getModel())).addChild((SPObject)newItem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return insertIndex;
    }

    @Override
    public void pasteData(Transferable t) {
    }
}

