/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.tasty;

import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyVersion;
import dotty.tools.tasty.UnpicklerConfig$;
import scala.Predef$;
import scala.collection.StringOps$;

public interface UnpicklerConfig {
    public static UnpicklerConfig generic() {
        return UnpicklerConfig$.MODULE$.generic();
    }

    public int majorVersion();

    public int minorVersion();

    public int experimentalVersion();

    public String upgradedReaderTool(TastyVersion var1);

    public String upgradedProducerTool(TastyVersion var1);

    public String recompileAdditionalInfo();

    public String upgradeAdditionalInfo(TastyVersion var1);

    public static interface DefaultTastyVersion
    extends UnpicklerConfig {
        public static int majorVersion$(DefaultTastyVersion $this) {
            return $this.majorVersion();
        }

        @Override
        default public int majorVersion() {
            return TastyFormat$.MODULE$.MajorVersion();
        }

        public static int minorVersion$(DefaultTastyVersion $this) {
            return $this.minorVersion();
        }

        @Override
        default public int minorVersion() {
            return TastyFormat$.MODULE$.MinorVersion();
        }

        public static int experimentalVersion$(DefaultTastyVersion $this) {
            return $this.experimentalVersion();
        }

        @Override
        default public int experimentalVersion() {
            return TastyFormat$.MODULE$.ExperimentalVersion();
        }
    }

    public static interface Generic
    extends UnpicklerConfig {
        public static String upgradedProducerTool$(Generic $this, TastyVersion version) {
            return $this.upgradedProducerTool(version);
        }

        @Override
        default public String upgradedProducerTool(TastyVersion version) {
            return "a later version";
        }

        public static String upgradedReaderTool$(Generic $this, TastyVersion version) {
            return $this.upgradedReaderTool(version);
        }

        @Override
        default public String upgradedReaderTool(TastyVersion version) {
            if (version.isExperimental()) {
                return new StringBuilder(47).append("the version of this tool compatible with TASTy ").append(version.show()).toString();
            }
            return new StringBuilder(51).append("a newer version of this tool compatible with TASTy ").append(version.show()).toString();
        }

        public static String recompileAdditionalInfo$(Generic $this) {
            return $this.recompileAdditionalInfo();
        }

        @Override
        default public String recompileAdditionalInfo() {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |  Usually this means that the classpath entry of this file should be updated."));
        }

        public static String upgradeAdditionalInfo$(Generic $this, TastyVersion fileVersion) {
            return $this.upgradeAdditionalInfo(fileVersion);
        }

        @Override
        default public String upgradeAdditionalInfo(TastyVersion fileVersion) {
            if (fileVersion.isExperimental() && this.experimentalVersion() == 0) {
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |  Note that this tool does not support reading experimental TASTy."));
            }
            return "";
        }
    }
}

