/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) + ivec4(-64, 72, 88, -76)) => ivec4(-128, 144, 176, -152)
 * (ivec4(-64, 72, 88, -76) + ivec4(64, 72, 88, 76)) => ivec4(0, 144, 176, 0)
 * (ivec4(-64, 72, 88, -76) + ivec4(-24, 40, -23, 64)) => ivec4(-88, 112, 65, -12)
 * (ivec4(-64, 72, 88, -76) + ivec4(24, 40, 23, 64)) => ivec4(-40, 112, 111, -12)
 * (ivec4(64, 72, 88, 76) + ivec4(-64, 72, 88, -76)) => ivec4(0, 144, 176, 0)
 * (ivec4(64, 72, 88, 76) + ivec4(64, 72, 88, 76)) => ivec4(128, 144, 176, 152)
 * (ivec4(64, 72, 88, 76) + ivec4(-24, 40, -23, 64)) => ivec4(40, 112, 65, 140)
 * (ivec4(64, 72, 88, 76) + ivec4(24, 40, 23, 64)) => ivec4(88, 112, 111, 140)
 * (ivec4(-24, 40, -23, 64) + ivec4(-64, 72, 88, -76)) => ivec4(-88, 112, 65, -12)
 * (ivec4(-24, 40, -23, 64) + ivec4(64, 72, 88, 76)) => ivec4(40, 112, 65, 140)
 * (ivec4(-24, 40, -23, 64) + ivec4(-24, 40, -23, 64)) => ivec4(-48, 80, -46, 128)
 * (ivec4(-24, 40, -23, 64) + ivec4(24, 40, 23, 64)) => ivec4(0, 80, 0, 128)
 * (ivec4(24, 40, 23, 64) + ivec4(-64, 72, 88, -76)) => ivec4(-40, 112, 111, -12)
 * (ivec4(24, 40, 23, 64) + ivec4(64, 72, 88, 76)) => ivec4(88, 112, 111, 140)
 * (ivec4(24, 40, 23, 64) + ivec4(-24, 40, -23, 64)) => ivec4(0, 80, 0, 128)
 * (ivec4(24, 40, 23, 64) + ivec4(24, 40, 23, 64)) => ivec4(48, 80, 46, 128)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) + ivec4(-64, 72, 88, -76)), ivec4(-128, 144, 176, -152))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) + ivec4(64, 72, 88, 76)), ivec4(0, 144, 176, 0))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) + ivec4(-24, 40, -23, 64)), ivec4(-88, 112, 65, -12))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) + ivec4(24, 40, 23, 64)), ivec4(-40, 112, 111, -12))) ? 1 : -1] array3;
  float[all(equal((ivec4(64, 72, 88, 76) + ivec4(-64, 72, 88, -76)), ivec4(0, 144, 176, 0))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) + ivec4(64, 72, 88, 76)), ivec4(128, 144, 176, 152))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) + ivec4(-24, 40, -23, 64)), ivec4(40, 112, 65, 140))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) + ivec4(24, 40, 23, 64)), ivec4(88, 112, 111, 140))) ? 1 : -1] array7;
  float[all(equal((ivec4(-24, 40, -23, 64) + ivec4(-64, 72, 88, -76)), ivec4(-88, 112, 65, -12))) ? 1 : -1] array8;
  float[all(equal((ivec4(-24, 40, -23, 64) + ivec4(64, 72, 88, 76)), ivec4(40, 112, 65, 140))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) + ivec4(-24, 40, -23, 64)), ivec4(-48, 80, -46, 128))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) + ivec4(24, 40, 23, 64)), ivec4(0, 80, 0, 128))) ? 1 : -1] array11;
  float[all(equal((ivec4(24, 40, 23, 64) + ivec4(-64, 72, 88, -76)), ivec4(-40, 112, 111, -12))) ? 1 : -1] array12;
  float[all(equal((ivec4(24, 40, 23, 64) + ivec4(64, 72, 88, 76)), ivec4(88, 112, 111, 140))) ? 1 : -1] array13;
  float[all(equal((ivec4(24, 40, 23, 64) + ivec4(-24, 40, -23, 64)), ivec4(0, 80, 0, 128))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) + ivec4(24, 40, 23, 64)), ivec4(48, 80, 46, 128))) ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
