/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.DSAnnotationReader;
import aQute.bnd.component.annotations.CollectionType;
import aQute.bnd.component.annotations.FieldOption;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.component.annotations.ReferencePolicy;
import aQute.bnd.component.annotations.ReferencePolicyOption;
import aQute.bnd.component.annotations.ReferenceScope;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.version.Version;
import aQute.bnd.xmlattribute.ExtensionDef;
import aQute.bnd.xmlattribute.Namespaces;
import aQute.bnd.xmlattribute.XMLAttributeFinder;
import aQute.lib.tag.Tag;

class ReferenceDef
extends ExtensionDef {
    String className;
    String bindDescriptor;
    Version version = DSAnnotationReader.V1_0;
    String name;
    String service;
    ReferenceCardinality cardinality;
    ReferencePolicy policy;
    ReferencePolicyOption policyOption;
    String target;
    String bind;
    String unbind;
    String updated;
    ReferenceScope scope;
    String field;
    FieldOption fieldOption;
    CollectionType collectionType;
    boolean isCollection;
    boolean isOptional;
    boolean isCollectionSubClass;
    Integer parameter;
    String reasonForVersion;

    public ReferenceDef(XMLAttributeFinder finder) {
        super(finder);
    }

    public void prepare(Analyzer analyzer) throws Exception {
        String error;
        if (this.name == null) {
            analyzer.error("No name for a reference", new Object[0]);
        }
        if (this.updated != null && !this.updated.equals("-")) {
            this.updateVersion(DSAnnotationReader.V1_2, "updated in reference");
        }
        if (this.policyOption != null) {
            this.updateVersion(DSAnnotationReader.V1_2, "policyOption");
        }
        if (this.target != null && (error = Verifier.validateFilter(this.target)) != null) {
            analyzer.error("Invalid target filter %s for %s", this.target, this.name);
        }
        if (this.service == null) {
            analyzer.error("No interface specified on %s", this.name);
        } else {
            Descriptors.TypeRef ref = analyzer.getTypeRefFromFQN(this.service);
            analyzer.nonClassReferTo(ref);
        }
        if (this.scope != null) {
            this.updateVersion(DSAnnotationReader.V1_3, "scope in reference");
        }
        if (this.field != null) {
            this.updateVersion(DSAnnotationReader.V1_3, "field reference");
        }
    }

    Tag getTag(Namespaces namespaces) {
        Tag tag = new Tag("reference", new Object[0]);
        tag.addAttribute("name", this.name).addAttribute("cardinality", (Object)this.cardinality).addAttribute("policy", (Object)this.policy).addAttribute("interface", this.service).addAttribute("target", this.target);
        if (!"-".equals(this.bind)) {
            tag.addAttribute("bind", this.bind);
        }
        if (!"-".equals(this.unbind)) {
            tag.addAttribute("unbind", this.unbind);
        }
        if (!"-".equals(this.updated)) {
            tag.addAttribute("updated", this.updated);
        }
        tag.addAttribute("policy-option", (Object)this.policyOption).addAttribute("scope", (Object)this.scope).addAttribute("field", this.field).addAttribute("field-option", (Object)this.fieldOption).addAttribute("field-collection-type", (Object)this.collectionType).addAttribute("parameter", this.parameter);
        this.addAttributes(tag, namespaces);
        return tag;
    }

    public String toString() {
        return this.name;
    }

    void updateVersion(Version version, String reason) {
        if (this.version.compareTo(version) >= 0) {
            return;
        }
        this.version = version;
        this.reasonForVersion = reason;
    }
}

