/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.util.ArrayUtil;

public class ColumnInfo
implements Formatable {
    int action;
    String name;
    DataTypeDescriptor dataType;
    DefaultInfo defaultInfo;
    ProviderInfo[] providers;
    DataValueDescriptor defaultValue;
    UUID newDefaultUUID;
    UUID oldDefaultUUID;
    long autoincStart;
    long autoincInc;
    boolean autoincCycle;
    long autoinc_create_or_modify_Start_Increment = -1L;
    public static final int CREATE = 0;
    public static final int DROP = 1;
    public static final int MODIFY_COLUMN_TYPE = 2;
    public static final int MODIFY_COLUMN_CONSTRAINT = 3;
    public static final int MODIFY_COLUMN_CONSTRAINT_NOT_NULL = 4;
    public static final int MODIFY_COLUMN_DEFAULT_RESTART = 5;
    public static final int MODIFY_COLUMN_DEFAULT_INCREMENT = 6;
    public static final int MODIFY_COLUMN_DEFAULT_VALUE = 7;
    public static final int MODIFY_COLUMN_GENERATED_ALWAYS = 8;
    public static final int MODIFY_COLUMN_GENERATED_BY_DEFAULT = 9;
    public static final int MODIFY_COLUMN_DEFAULT_CYCLE = 10;

    public ColumnInfo() {
    }

    public ColumnInfo(String name, DataTypeDescriptor dataType, DataValueDescriptor defaultValue, DefaultInfo defaultInfo, ProviderInfo[] providers, UUID newDefaultUUID, UUID oldDefaultUUID, int action, long autoincStart, long autoincInc, boolean autoincCycle, long autoinc_create_or_modify_Start_Increment) {
        this.name = name;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.defaultInfo = defaultInfo;
        this.providers = (ProviderInfo[])ArrayUtil.copy((Object[])providers);
        this.newDefaultUUID = newDefaultUUID;
        this.oldDefaultUUID = oldDefaultUUID;
        this.action = action;
        this.autoincStart = autoincStart;
        this.autoincInc = autoincInc;
        this.autoincCycle = autoincCycle;
        this.autoinc_create_or_modify_Start_Increment = autoinc_create_or_modify_Start_Increment;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.name = (String)fh.get("name");
        this.dataType = (DataTypeDescriptor)fh.get("dataType");
        this.defaultValue = (DataValueDescriptor)fh.get("defaultValue");
        this.defaultInfo = (DefaultInfo)fh.get("defaultInfo");
        this.newDefaultUUID = (UUID)fh.get("newDefaultUUID");
        this.oldDefaultUUID = (UUID)fh.get("oldDefaultUUID");
        this.action = fh.getInt("action");
        if (fh.get("autoincStart") != null) {
            this.autoincStart = fh.getLong("autoincStart");
            this.autoincInc = fh.getLong("autoincInc");
        } else {
            this.autoincStart = 0L;
            this.autoincInc = 0L;
        }
        FormatableArrayHolder fah = (FormatableArrayHolder)fh.get("providers");
        if (fah != null) {
            this.providers = (ProviderInfo[])fah.getArray(ProviderInfo[].class);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("name", this.name);
        fh.put("dataType", this.dataType);
        fh.put("defaultValue", this.defaultValue);
        fh.put("defaultInfo", this.defaultInfo);
        fh.put("newDefaultUUID", this.newDefaultUUID);
        fh.put("oldDefaultUUID", this.oldDefaultUUID);
        fh.putInt("action", this.action);
        if (this.autoincInc != 0L) {
            fh.putLong("autoincStart", this.autoincStart);
            fh.putLong("autoincInc", this.autoincInc);
        }
        if (this.providers != null) {
            FormatableArrayHolder fah = new FormatableArrayHolder(this.providers);
            fh.put("providers", fah);
        }
        out.writeObject(fh);
    }

    @Override
    public int getTypeFormatId() {
        return 358;
    }

    public DataTypeDescriptor getDataType() {
        return this.dataType;
    }

    public String toString() {
        Object traceName = this.name == null ? "name: null " : "name: " + this.name + " ";
        Object traceDataType = this.dataType == null ? "dataType: null " : "dataType: " + String.valueOf(this.dataType) + " ";
        Object traceDefaultValue = this.defaultValue == null ? "defaultValue: null " : "defaultValue: " + String.valueOf(this.defaultValue) + " ";
        Object traceDefaultInfo = this.defaultInfo == null ? "defaultInfo: null " : "defaultInfo: " + String.valueOf(this.defaultInfo) + " ";
        Object traceNewDefaultUUID = this.newDefaultUUID == null ? "newDefaultUUID: null " : "newDefaultUUID: " + String.valueOf(this.newDefaultUUID) + " ";
        Object traceOldDefaultUUID = this.oldDefaultUUID == null ? "oldDefaultUUID: null " : "oldDefaultUUID: " + String.valueOf(this.oldDefaultUUID) + " ";
        String traceAction = "action: " + this.action + " ";
        Object traceAI = this.autoincInc != 0L ? "autoincrement, start: " + this.autoincStart + " increment:" + this.autoincInc : "NOT autoincrement";
        return "ColumnInfo: (" + (String)traceName + (String)traceDataType + (String)traceDefaultValue + (String)traceDefaultInfo + (String)traceNewDefaultUUID + (String)traceOldDefaultUUID + traceAction + (String)traceAI + ")";
    }
}

