/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class OpenTelemetryMpContextPropagationProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        final Context context = QuarkusContextStorage.INSTANCE.current();
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                final Context currentContext = QuarkusContextStorage.INSTANCE.current();
                if (context != null) {
                    QuarkusContextStorage.INSTANCE.attach(context);
                    return new ThreadContextController(){

                        public void endContext() throws IllegalStateException {
                            Span span = Span.fromContext((Context)currentContext);
                            if (span != null && span.isRecording()) {
                                QuarkusContextStorage.INSTANCE.attach(currentContext);
                            }
                        }
                    };
                }
                return new ThreadContextController(){

                    public void endContext() throws IllegalStateException {
                    }
                };
            }
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                return new ThreadContextController(){

                    public void endContext() throws IllegalStateException {
                    }
                };
            }
        };
    }

    public String getThreadContextType() {
        return "OpenTelemetry";
    }
}

