/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.vertx.core.spi.logging.LogDelegate;
import java.util.logging.LogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public class VertxLogDelegate
implements LogDelegate {
    private final Logger logger;

    public VertxLogDelegate(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.INFO);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t, new Object[0]);
    }

    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    public void error(Object message, Object ... params) {
        this.log(Level.ERROR, message, null, params);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t, new Object[0]);
    }

    public void error(Object message, Throwable t, Object ... params) {
        this.log(Level.ERROR, message, t, params);
    }

    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    public void warn(Object message, Object ... params) {
        this.log(Level.WARN, message, null, params);
    }

    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t, new Object[0]);
    }

    public void warn(Object message, Throwable t, Object ... params) {
        this.log(Level.WARN, message, t, params);
    }

    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    public void info(Object message, Object ... params) {
        this.log(Level.INFO, message, null, params);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t, new Object[0]);
    }

    public void info(Object message, Throwable t, Object ... params) {
        this.log(Level.INFO, message, t, params);
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    public void debug(Object message, Object ... params) {
        this.log(Level.DEBUG, message, null, params);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t, new Object[0]);
    }

    public void debug(Object message, Throwable t, Object ... params) {
        this.log(Level.DEBUG, message, t, params);
    }

    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    public void trace(Object message, Object ... params) {
        this.log(Level.TRACE, message, null, params);
    }

    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t, new Object[0]);
    }

    public void trace(Object message, Throwable t, Object ... params) {
        this.log(Level.TRACE, message, t, params);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null, new Object[0]);
    }

    private void log(Level level, Object message, Throwable t, Object ... params) {
        if (!this.logger.isLoggable((java.util.logging.Level)level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record = new LogRecord((java.util.logging.Level)level, msg);
        record.setLoggerName(this.logger.getName());
        if (t != null) {
            record.setThrown(t);
        } else if (params != null && params.length != 0 && params[params.length - 1] instanceof Throwable) {
            record.setThrown((Throwable)params[params.length - 1]);
        }
        record.setSourceClassName(null);
        record.setParameters(params);
        this.logger.log(record);
    }
}

