/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission.evaluator;

import java.util.Collection;
import java.util.HashMap;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.Permissions;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;

public class UnboundedPermissionEvaluator
implements PermissionEvaluator {
    private final EvaluationContext executionContext;
    private final AuthorizationProvider authorizationProvider;
    private final PolicyEvaluator policyEvaluator;
    private final ResourceServer resourceServer;
    private final AuthorizationRequest request;

    UnboundedPermissionEvaluator(EvaluationContext executionContext, AuthorizationProvider authorizationProvider, ResourceServer resourceServer, AuthorizationRequest request) {
        this.executionContext = executionContext;
        this.authorizationProvider = authorizationProvider;
        this.policyEvaluator = authorizationProvider.getPolicyEvaluator(resourceServer);
        this.resourceServer = resourceServer;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Decision evaluate(Decision decision) {
        StoreFactory storeFactory = this.authorizationProvider.getStoreFactory();
        try {
            HashMap decisionCache = new HashMap();
            storeFactory.setReadOnly(true);
            Permissions.all(this.resourceServer, this.executionContext.getIdentity(), this.authorizationProvider, this.request, permission -> this.policyEvaluator.evaluate((ResourcePermission)permission, this.authorizationProvider, this.executionContext, decision, decisionCache));
            decision.onComplete();
        }
        catch (Throwable cause) {
            decision.onError(cause);
        }
        finally {
            storeFactory.setReadOnly(false);
        }
        return decision;
    }

    @Override
    public Collection<Permission> evaluate(ResourceServer resourceServer, AuthorizationRequest request) {
        DecisionPermissionCollector decision = new DecisionPermissionCollector(this.authorizationProvider, resourceServer, request);
        this.evaluate(decision);
        return decision.results();
    }
}

