/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.coin.EndpointProvider;
import org.jitsi.xmpp.extensions.coin.ParsingUtils;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jitsi.xmpp.extensions.coin.UserPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class UserProvider
extends ExtensionElementProvider<UserPacketExtension> {
    @Override
    public UserPacketExtension parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        String entity = parser.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        if (entity == null) {
            throw new SmackParsingException.RequiredAttributeMissingException("Coin user element must contain entity attribute");
        }
        UserPacketExtension ext = new UserPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("display-text")) {
                    ext.setDisplayText(ParsingUtils.parseText(parser));
                    continue;
                }
                if (!elementName.equals("endpoint")) continue;
                EndpointProvider provider = new EndpointProvider();
                ext.addChildExtension((ExtensionElement)provider.parse(parser));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("user")) continue;
            done = true;
        }
        return ext;
    }
}

