/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ElasticIpAssociationDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssociateAddress
extends BaseCmd {
    private static final String[] INSTANCE_DESC = new String[]{"Instance with which to associate an EIP."};
    private static final String[] NETWORK_INTERFACE_DESC = new String[]{"Network interface with which to associate an EIP."};
    private static final String[] PRIVATE_IP_ADDRESS_DESC = new String[]{"Private IP address with which to associate an EIP."};
    public static final String[] ALLOW_REASSOCIATION_DESC = new String[]{"Allows an Elastic IP address that is already associated with an ", "instance or a network interface to be re-associated with the ", "specified instance or network interface. Otherwise, the operation ", "fails."};

    public AssociateAddress(String[] args) {
        super("ec2assocaddr", "ec2-associate-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(INSTANCE_DESC));
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"network-interface");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(NETWORK_INTERFACE_DESC));
        result.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"private-ip-address");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(PRIVATE_IP_ADDRESS_DESC));
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"allocation-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(ALLOCATION_ID_DESC));
        result.addOption(OptionBuilder.create((String)"a"));
        result.addOption(AssociateAddress.createOption(null, "allow-reassociation", ALLOW_REASSOCIATION_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "{ IP | -a ALLOCATION_ID } { -i INSTANCE | -n NETWORK_INTERFACE }";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("allocation-id");
        this.printOption("instance");
        this.printOption("network-interface");
        this.printOption("private-ip-address");
        this.printOption("allow-reassociation");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Associate a public address with an instance or a network interface.");
        System.out.println("     The IP parameter is the address to associate for non-VPC instances.");
        System.out.println("     VPC instances must specify an allocation ID, or private IP address ");
        System.out.println("     instead.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String publicIp;
        String allocationId;
        String networkInterfaceId;
        String instanceId;
        String privateIp = null;
        this.assertOnlyOneOptionSet(new String[]{"instance", "network-interface"});
        if (this.isOptionSet("instance")) {
            instanceId = this.getOptionValue("instance");
            networkInterfaceId = null;
        } else {
            instanceId = null;
            networkInterfaceId = this.getOptionValue("network-interface");
        }
        if (this.isOptionSet("allocation-id")) {
            if (this.getNonOptions().length > 0) {
                throw new InvalidArgumentCombination("Specify either IP (non-VPC) or -a allocation-id (VPC), not both.");
            }
            allocationId = this.getOptionValue("allocation-id");
            publicIp = null;
        } else {
            this.assertNonOptionSet("IP");
            publicIp = this.getNonOptions()[0];
            allocationId = null;
            this.warnIfTooManyNonOptions();
        }
        if (this.isOptionSet("private-ip-address")) {
            privateIp = this.getOptionValue("private-ip-address");
        }
        Boolean allowReassociation = null;
        if (this.isOptionSet("allow-reassociation")) {
            allowReassociation = Boolean.TRUE;
        }
        RequestResultPair resPair = jec2.associateAddress(publicIp, instanceId, networkInterfaceId, allocationId, privateIp, allowReassociation);
        out.outputAddressAssociation(System.out, publicIp, instanceId, networkInterfaceId, allocationId, ((ElasticIpAssociationDescription)resPair.getResponse()).getAssociationId(), privateIp);
        out.printRequestId(System.out, resPair.getRequestId());
        return true;
    }

    public static void main(String[] args) {
        new AssociateAddress(args).invoke();
    }
}

