/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.netbeans.modules.sampler.Sampler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String NOT_SUPPORTED = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_NotSupported");
    private final AtomicReference<Sampler> RUNNING = new AtomicReference();

    public SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("ShortDescription", ACTION_NAME_START);
        this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Sampler sampler = Sampler.createManualSampler((String)"Self Sampler");
        if (sampler != null) {
            if (this.RUNNING.compareAndSet(null, sampler)) {
                this.putValue("Name", ACTION_NAME_STOP);
                this.putValue("ShortDescription", ACTION_NAME_STOP);
                this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSamplerRunning.png");
                sampler.start();
            } else {
                sampler = this.RUNNING.getAndSet(null);
                if (sampler != null) {
                    final Sampler sampler2 = sampler;
                    this.setEnabled(false);
                    SwingWorker swingWorker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            sampler2.stop();
                            return null;
                        }

                        @Override
                        protected void done() {
                            SelfSamplerAction.this.putValue("Name", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("ShortDescription", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
                            SelfSamplerAction.this.setEnabled(true);
                        }
                    };
                    swingWorker.execute();
                }
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NOT_SUPPORTED, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, aWTEvent.getID(), "shortcut"));
            keyEvent.consume();
        }
    }

    final boolean isProfileMe(Sampler sampler) {
        return sampler == this.RUNNING.get();
    }
}

