/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.CurrentMillisClock;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSet;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.SilenceableBidiStream;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.TargetChange;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class Watch
implements BidiStreamObserver<ListenRequest, ListenResponse> {
    private static final Logger LOGGER = Logger.getLogger(Watch.class.getName());
    private static final int WATCH_TARGET_ID = 1;
    private final FirestoreImpl firestore;
    private final ScheduledExecutorService firestoreExecutor;
    private final Query query;
    private final Comparator<QueryDocumentSnapshot> comparator;
    private final ExponentialRetryAlgorithm backoff;
    private final Target target;
    private TimedAttemptSettings nextAttempt;
    private SilenceableBidiStream<ListenRequest, ListenResponse> stream;
    private DocumentSet documentSet;
    private Map<ResourcePath, Document> changeMap;
    private ByteString resumeToken;
    private EventListener<QuerySnapshot> listener;
    private Executor userCallbackExecutor;
    private boolean current;
    private boolean hasPushed;
    private final AtomicBoolean isActive;

    private Watch(FirestoreImpl firestore, Query query, Target target) {
        this.firestore = firestore;
        this.target = target;
        this.query = query;
        this.comparator = query.comparator();
        this.backoff = new ExponentialRetryAlgorithm(firestore.getOptions().getRetrySettings(), CurrentMillisClock.getDefaultClock());
        this.firestoreExecutor = firestore.getClient().getExecutor();
        this.isActive = new AtomicBoolean();
        this.nextAttempt = this.backoff.createFirstAttempt();
    }

    static Watch forDocument(DocumentReference documentReference) {
        Target.Builder target = Target.newBuilder();
        target.getDocumentsBuilder().addDocuments(documentReference.getName());
        target.setTargetId(1);
        return new Watch((FirestoreImpl)documentReference.getFirestore(), documentReference.getParent(), target.build());
    }

    static Watch forQuery(Query query) {
        Target.Builder target = Target.newBuilder();
        target.setQuery(Target.QueryTarget.newBuilder().setStructuredQuery(query.buildQuery()).setParent(query.options.getParentPath().getName()).build());
        target.setTargetId(1);
        return new Watch((FirestoreImpl)query.getFirestore(), query, target.build());
    }

    public void onStart(StreamController streamController) {
    }

    public void onReady(ClientStream<ListenRequest> clientStream) {
    }

    public synchronized void onResponse(ListenResponse listenResponse) {
        switch (listenResponse.getResponseTypeCase()) {
            case TARGET_CHANGE: {
                TargetChange change = listenResponse.getTargetChange();
                boolean noTargetIds = change.getTargetIdsCount() == 0;
                switch (change.getTargetChangeType()) {
                    case NO_CHANGE: {
                        if (!noTargetIds || !change.hasReadTime() || !this.current) break;
                        this.pushSnapshot(Timestamp.fromProto((com.google.protobuf.Timestamp)change.getReadTime()), change.getResumeToken());
                        break;
                    }
                    case ADD: {
                        if (1 == change.getTargetIds(0)) break;
                        this.closeStream((Throwable)((Object)FirestoreException.forInvalidArgument("Target ID must be 0x01", new Object[0])));
                        break;
                    }
                    case REMOVE: {
                        Status status = change.hasCause() ? Status.fromCodeValue((int)change.getCause().getCode()) : Status.CANCELLED;
                        this.closeStream((Throwable)((Object)FirestoreException.forServerRejection(status, "Backend ended Listen stream: " + change.getCause().getMessage(), new Object[0])));
                        break;
                    }
                    case CURRENT: {
                        this.current = true;
                        break;
                    }
                    case RESET: {
                        this.resetDocs();
                        break;
                    }
                    default: {
                        this.closeStream((Throwable)((Object)FirestoreException.forInvalidArgument("Encountered invalid target change type: " + change.getTargetChangeType(), new Object[0])));
                    }
                }
                if (change.getResumeToken() == null || !this.affectsTarget(change.getTargetIdsList(), 1)) break;
                this.nextAttempt = this.backoff.createFirstAttempt();
                break;
            }
            case DOCUMENT_CHANGE: {
                List targetIds = listenResponse.getDocumentChange().getTargetIdsList();
                List removedTargetIds = listenResponse.getDocumentChange().getRemovedTargetIdsList();
                boolean changed = targetIds.contains(1);
                boolean removed = removedTargetIds.contains(1);
                Document document = listenResponse.getDocumentChange().getDocument();
                ResourcePath name = ResourcePath.create(document.getName());
                if (changed) {
                    this.changeMap.put(name, document);
                    break;
                }
                if (!removed) break;
                this.changeMap.put(name, null);
                break;
            }
            case DOCUMENT_DELETE: {
                this.changeMap.put(ResourcePath.create(listenResponse.getDocumentDelete().getDocument()), null);
                break;
            }
            case DOCUMENT_REMOVE: {
                this.changeMap.put(ResourcePath.create(listenResponse.getDocumentRemove().getDocument()), null);
                break;
            }
            case FILTER: {
                int filterCount = listenResponse.getFilter().getCount();
                int currentSize = this.currentSize();
                if (filterCount == currentSize) break;
                LOGGER.info(() -> String.format("filter: count mismatch filter count %d != current size %d", filterCount, currentSize));
                this.resetDocs();
                this.resetStream();
                break;
            }
            default: {
                this.closeStream((Throwable)((Object)FirestoreException.forInvalidArgument("Encountered invalid listen response type", new Object[0])));
            }
        }
    }

    public synchronized void onError(Throwable throwable) {
        this.maybeReopenStream(throwable);
    }

    public synchronized void onComplete() {
        this.maybeReopenStream((Throwable)new StatusException(Status.fromCode((Status.Code)Status.Code.UNKNOWN)));
    }

    ListenerRegistration runWatch(Executor userCallbackExecutor, EventListener<QuerySnapshot> listener) {
        boolean watchStarted = this.isActive.compareAndSet(false, true);
        Preconditions.checkState((boolean)watchStarted, (Object)"Can't restart an already active watch");
        this.userCallbackExecutor = userCallbackExecutor;
        this.listener = listener;
        this.stream = null;
        this.documentSet = DocumentSet.emptySet(this.comparator);
        this.changeMap = new HashMap<ResourcePath, Document>();
        this.resumeToken = null;
        this.current = false;
        this.initStream();
        return () -> {
            this.isActive.set(false);
            this.firestore.getClient().getExecutor().execute(() -> {
                Watch watch = this;
                synchronized (watch) {
                    this.stream.closeSend();
                    this.stream = null;
                }
            });
        };
    }

    private int currentSize() {
        ChangeSet changeSet = this.extractChanges(Timestamp.now());
        return this.documentSet.size() + changeSet.adds.size() - changeSet.deletes.size();
    }

    private void resetDocs() {
        this.changeMap.clear();
        this.resumeToken = null;
        for (DocumentSnapshot snapshot : this.documentSet) {
            this.changeMap.put(snapshot.getReference().getResourcePath(), null);
        }
        this.current = false;
    }

    private void closeStream(Throwable throwable) {
        if (this.stream != null) {
            this.stream.closeSendAndSilence();
            this.stream = null;
        }
        if (this.isActive.getAndSet(false)) {
            this.userCallbackExecutor.execute(() -> {
                if (throwable instanceof FirestoreException) {
                    this.listener.onEvent(null, (FirestoreException)((Object)((Object)throwable)));
                } else {
                    Status status = Watch.getStatus(throwable);
                    FirestoreException firestoreException = FirestoreException.forApiException(new ApiException(throwable, (StatusCode)GrpcStatusCode.of((Status.Code)(status != null ? status.getCode() : Status.Code.UNKNOWN)), false));
                    this.listener.onEvent(null, firestoreException);
                }
            });
        }
    }

    private void maybeReopenStream(Throwable throwable) {
        if (this.isActive.get() && !Watch.isPermanentError(throwable)) {
            if (Watch.isResourceExhaustedError(throwable)) {
                this.nextAttempt = this.backoff.createNextAttempt(this.nextAttempt);
            }
            this.changeMap.clear();
            this.resetStream();
        } else {
            this.closeStream(throwable);
        }
    }

    private void resetStream() {
        if (this.stream != null) {
            this.stream.closeSendAndSilence();
            this.stream = null;
        }
        this.initStream();
    }

    private void initStream() {
        this.firestoreExecutor.schedule(() -> {
            try {
                if (!this.isActive.get()) {
                    return;
                }
                Watch watch = this;
                synchronized (watch) {
                    if (!this.isActive.get()) {
                        return;
                    }
                    Preconditions.checkState((this.stream == null ? 1 : 0) != 0);
                    this.current = false;
                    this.nextAttempt = this.backoff.createNextAttempt(this.nextAttempt);
                    this.stream = new SilenceableBidiStream<ListenRequest, ListenResponse>(this, observer -> this.firestore.streamRequest(observer, this.firestore.getClient().listenCallable()));
                    ListenRequest.Builder request = ListenRequest.newBuilder();
                    request.setDatabase(this.firestore.getDatabaseName());
                    request.setAddTarget(this.target);
                    if (this.resumeToken != null) {
                        request.getAddTargetBuilder().setResumeToken(this.resumeToken);
                    }
                    this.stream.send(request.build());
                }
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
        }, this.nextAttempt.getRandomizedRetryDelay().toMillis(), TimeUnit.MILLISECONDS);
    }

    private boolean affectsTarget(List<Integer> targetIds, int currentId) {
        return targetIds == null || targetIds.isEmpty() || targetIds.contains(currentId);
    }

    private ChangeSet extractChanges(Timestamp readTime) {
        ChangeSet changeSet = new ChangeSet();
        for (Map.Entry<ResourcePath, Document> change : this.changeMap.entrySet()) {
            if (change.getValue() == null) {
                if (!this.documentSet.contains(change.getKey())) continue;
                changeSet.deletes.add(this.documentSet.getDocument(change.getKey()));
                continue;
            }
            QueryDocumentSnapshot snapshot = QueryDocumentSnapshot.fromDocument(this.firestore, readTime, change.getValue());
            if (this.documentSet.contains(change.getKey())) {
                changeSet.updates.add(snapshot);
                continue;
            }
            changeSet.adds.add(snapshot);
        }
        return changeSet;
    }

    private void pushSnapshot(Timestamp readTime, ByteString nextResumeToken) {
        List<DocumentChange> changes = this.computeSnapshot(readTime);
        if (!this.hasPushed || !changes.isEmpty()) {
            QuerySnapshot querySnapshot = QuerySnapshot.withChanges(this.query, readTime, this.documentSet, changes);
            LOGGER.fine(querySnapshot::toString);
            this.userCallbackExecutor.execute(() -> this.listener.onEvent(querySnapshot, null));
            this.hasPushed = true;
        }
        this.changeMap.clear();
        this.resumeToken = nextResumeToken;
    }

    private DocumentChange deleteDoc(QueryDocumentSnapshot oldDocument) {
        ResourcePath resourcePath = oldDocument.getReference().getResourcePath();
        int oldIndex = this.documentSet.indexOf(resourcePath);
        this.documentSet = this.documentSet.remove(resourcePath);
        return new DocumentChange(oldDocument, DocumentChange.Type.REMOVED, oldIndex, -1);
    }

    private DocumentChange addDoc(QueryDocumentSnapshot newDocument) {
        ResourcePath resourcePath = newDocument.getReference().getResourcePath();
        this.documentSet = this.documentSet.add(newDocument);
        int newIndex = this.documentSet.indexOf(resourcePath);
        return new DocumentChange(newDocument, DocumentChange.Type.ADDED, -1, newIndex);
    }

    @Nullable
    private DocumentChange modifyDoc(QueryDocumentSnapshot newDocument) {
        ResourcePath resourcePath = newDocument.getReference().getResourcePath();
        QueryDocumentSnapshot oldDocument = this.documentSet.getDocument(resourcePath);
        if (!oldDocument.getUpdateTime().equals((Object)newDocument.getUpdateTime())) {
            int oldIndex = this.documentSet.indexOf(resourcePath);
            this.documentSet = this.documentSet.remove(resourcePath);
            this.documentSet = this.documentSet.add(newDocument);
            int newIndex = this.documentSet.indexOf(resourcePath);
            return new DocumentChange(newDocument, DocumentChange.Type.MODIFIED, oldIndex, newIndex);
        }
        return null;
    }

    private List<DocumentChange> computeSnapshot(Timestamp readTime) {
        ArrayList<DocumentChange> appliedChanges = new ArrayList<DocumentChange>();
        ChangeSet changeSet = this.extractChanges(readTime);
        changeSet.deletes.sort(this.comparator);
        for (QueryDocumentSnapshot delete : changeSet.deletes) {
            appliedChanges.add(this.deleteDoc(delete));
        }
        changeSet.adds.sort(this.comparator);
        for (QueryDocumentSnapshot add : changeSet.adds) {
            appliedChanges.add(this.addDoc(add));
        }
        changeSet.updates.sort(this.comparator);
        for (QueryDocumentSnapshot update : changeSet.updates) {
            DocumentChange change = this.modifyDoc(update);
            if (change == null) continue;
            appliedChanges.add(change);
        }
        return appliedChanges;
    }

    private static boolean isPermanentError(Throwable throwable) {
        Status status = Watch.getStatus(throwable);
        if (status == null) {
            return true;
        }
        switch (status.getCode()) {
            case CANCELLED: 
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case RESOURCE_EXHAUSTED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case UNAUTHENTICATED: {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Status getStatus(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)throwable).getStatus();
        }
        if (throwable instanceof StatusException) {
            return ((StatusException)throwable).getStatus();
        }
        if (throwable instanceof ApiException && ((ApiException)throwable).getStatusCode().getTransportCode() instanceof Status.Code) {
            return ((Status.Code)((ApiException)throwable).getStatusCode().getTransportCode()).toStatus();
        }
        return null;
    }

    private static boolean isResourceExhaustedError(Throwable throwable) {
        Status status = Watch.getStatus(throwable);
        return status != null && status.getCode().equals((Object)Status.Code.RESOURCE_EXHAUSTED);
    }

    static class ChangeSet {
        List<QueryDocumentSnapshot> deletes = new ArrayList<QueryDocumentSnapshot>();
        List<QueryDocumentSnapshot> adds = new ArrayList<QueryDocumentSnapshot>();
        List<QueryDocumentSnapshot> updates = new ArrayList<QueryDocumentSnapshot>();

        ChangeSet() {
        }
    }
}

