/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.EnginePrivate;

public class PlainScriptConduit
extends BaseScriptConduit {
    private final String scriptTagProtection;
    private boolean chunkOpen = false;
    private static final Log log = LogFactory.getLog(PlainScriptConduit.class);

    public PlainScriptConduit(PrintWriter out, String instanceId, String scriptTagProtection) {
        super(out, instanceId);
        this.scriptTagProtection = scriptTagProtection;
    }

    @Override
    public String getOutboundMimeType() {
        return "text/javascript; charset=utf-8";
    }

    @Override
    public void beginStreamAndChunk() {
        if (this.scriptTagProtection != null) {
            this.out.println(this.scriptTagProtection);
        }
    }

    @Override
    public void beginChunk() {
        if (!this.chunkOpen) {
            this.out.println("//#DWR-START#");
            this.out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, false, null));
            this.chunkOpen = true;
        }
    }

    @Override
    public void sendScript(String script) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execution time: " + new Date().toString() + " - Writing to response: " + script));
        }
        this.beginChunk();
        this.out.println(script);
    }

    @Override
    public void endChunk() {
        if (this.chunkOpen) {
            this.out.println(EnginePrivate.remoteEndWrapper(this.instanceId, false));
            this.out.println("//#DWR-END#");
            this.chunkOpen = false;
        }
    }

    @Override
    public void endStreamAndChunk() throws IOException {
        this.endChunk();
    }
}

