/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.fgap.evaluation.partial.PartialEvaluationContext;
import org.keycloak.authorization.fgap.evaluation.partial.PartialEvaluationStorageProvider;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;

public interface JpaUserPartialEvaluationProvider
extends PartialEvaluationStorageProvider {
    public KeycloakSession getSession();

    public EntityManager getEntityManager();

    default public List<Predicate> getFilters(PartialEvaluationContext context) {
        KeycloakSession session = this.getSession();
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            Set userGroups = (Set)session.getAttribute("keycloak.session.realm.users.query.groups");
            if (userGroups != null) {
                return List.of(this.getFilterByGroupMembership(session, context, userGroups));
            }
            return List.of();
        }
        return Optional.ofNullable(this.getAllowedGroupFilters(context)).map(List::of).orElse(List.of());
    }

    default public List<Predicate> getNegateFilters(PartialEvaluationContext context) {
        return Optional.ofNullable(this.getDeniedGroupsFilters(context)).map(List::of).orElse(List.of());
    }

    private Predicate getAllowedGroupFilters(PartialEvaluationContext context) {
        Set allowedGroups = context.getAllowedGroups();
        if (allowedGroups.isEmpty()) {
            return null;
        }
        if (context.deniedResources().contains("Users")) {
            return null;
        }
        if (context.isResourceTypeAllowed()) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        if (allowedGroups.contains("Groups")) {
            return cb.exists(this.createUserMembershipSubquery(context));
        }
        return cb.exists(this.createUserMembershipSubquery(context, root -> root.get("groupId").in((Collection)allowedGroups)));
    }

    private Predicate getDeniedGroupsFilters(PartialEvaluationContext context) {
        CriteriaBuilder cb = context.getCriteriaBuilder();
        Set allowedGroups = context.getAllowedGroups();
        Set deniedGroups = context.getDeniedGroups();
        if (deniedGroups.contains("Groups")) {
            Predicate notMembers = cb.not((Expression)cb.exists(this.createUserMembershipSubquery(context)));
            if (context.isResourceTypeAllowed()) {
                if (allowedGroups.isEmpty()) {
                    if (context.getDeniedGroupIds().isEmpty()) {
                        return cb.and(new Predicate[]{cb.or((Expression)notMembers, (Expression)context.getPath().get("id").in((Collection)context.getAllowedResourceIds()))});
                    }
                    return notMembers;
                }
                Predicate onlySpecificGroups = cb.exists(this.createUserMembershipSubquery(context, root -> root.get("groupId").in((Collection)allowedGroups)));
                return cb.and(new Predicate[]{cb.or((Expression)notMembers, (Expression)onlySpecificGroups)});
            }
            return cb.not((Expression)cb.exists(this.createUserMembershipSubquery(context, root -> root.get("groupId").in((Collection)context.getDeniedGroupIds()))));
        }
        if (context.getAllowedResources().isEmpty() && (allowedGroups.isEmpty() || context.deniedResources().contains("Users"))) {
            return null;
        }
        if (deniedGroups.isEmpty()) {
            return null;
        }
        return cb.not((Expression)cb.exists(this.createUserMembershipSubquery(context, root -> root.get("groupId").in((Collection)deniedGroups))));
    }

    private Subquery<?> createUserMembershipSubquery(PartialEvaluationContext context) {
        return this.createUserMembershipSubquery(context, null);
    }

    private Subquery<?> createUserMembershipSubquery(PartialEvaluationContext context, Function<Root<?>, Predicate> predicate) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = context.criteriaQuery();
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(UserGroupMembershipEntity.class);
        subquery.select(cb.literal((Object)1));
        Path root = context.getPath();
        ArrayList<Predicate> finalPredicates = new ArrayList<Predicate>();
        if (predicate != null) {
            finalPredicates.add(predicate.apply(from));
        }
        finalPredicates.add(cb.equal((Expression)from.get("user").get("id"), (Expression)root.get("id")));
        subquery.where((Predicate[])finalPredicates.toArray(Predicate[]::new));
        return subquery;
    }

    @Deprecated
    private Predicate getFilterByGroupMembership(KeycloakSession session, PartialEvaluationContext context, Set<String> groupIds) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = context.criteriaQuery();
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(UserGroupMembershipEntity.class);
        subquery.select(cb.literal((Object)1));
        ArrayList<Predicate> subPredicates = new ArrayList<Predicate>();
        subPredicates.add(from.get("groupId").in(groupIds));
        Path root = context.getPath();
        subPredicates.add(cb.equal((Expression)from.get("user").get("id"), (Expression)root.get("id")));
        Subquery subquery1 = query.subquery(Integer.class);
        subquery1.select(cb.literal((Object)1));
        Root from1 = subquery1.from(ResourceEntity.class);
        ArrayList<Predicate> subs = new ArrayList<Predicate>();
        Path groupId = from.get("groupId");
        RealmModel realm = session.getContext().getRealm();
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(realm)) {
            subs.add(cb.like((Expression)from1.get("name"), (Expression)groupId));
        } else {
            subs.add(cb.like((Expression)from1.get("name"), cb.concat("group.resource.", (Expression)groupId)));
        }
        subquery1.where((Predicate[])subs.toArray(Predicate[]::new));
        subPredicates.add(cb.exists(subquery1));
        subquery.where((Predicate[])subPredicates.toArray(Predicate[]::new));
        return cb.exists(subquery);
    }
}

