/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.HashMap;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Block {
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;
    static final boolean DEBUG = false;
    private static int debug_blockCount;

    Block(int n, int n2) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
    }

    static void runFlowAnalyzes(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n = optFunctionNode.fnode.getParamCount();
        int n2 = optFunctionNode.fnode.getParamAndVarCount();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 != n) {
            nArray[n3] = 3;
            ++n3;
        }
        n3 = n;
        while (n3 != n2) {
            nArray[n3] = 0;
            ++n3;
        }
        Block[] blockArray = Block.buildBlocks(nodeArray);
        Block.reachingDefDataFlow(optFunctionNode, nodeArray, blockArray, nArray);
        Block.typeFlow(optFunctionNode, nodeArray, blockArray, nArray);
        int n4 = n;
        while (n4 != n2) {
            if (nArray[n4] == 1) {
                optFunctionNode.setIsNumberVar(n4);
            }
            ++n4;
        }
    }

    private static Block[] buildBlocks(Node[] nodeArray) {
        Object object;
        FatBlock fatBlock;
        HashMap<Node, FatBlock> hashMap = new HashMap<Node, FatBlock>();
        ObjArray objArray = new ObjArray();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeArray.length) {
            switch (nodeArray[n2].getType()) {
                case 130: {
                    if (n2 == n) break;
                    fatBlock = Block.newFatBlock(n, n2 - 1);
                    if (nodeArray[n].getType() == 130) {
                        hashMap.put(nodeArray[n], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n = n2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    fatBlock = Block.newFatBlock(n, n2);
                    if (nodeArray[n].getType() == 130) {
                        hashMap.put(nodeArray[n], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n = n2 + 1;
                }
            }
            ++n2;
        }
        if (n != nodeArray.length) {
            FatBlock fatBlock2 = Block.newFatBlock(n, nodeArray.length - 1);
            if (nodeArray[n].getType() == 130) {
                hashMap.put(nodeArray[n], fatBlock2);
            }
            objArray.add(fatBlock2);
        }
        int n3 = 0;
        while (n3 < objArray.size()) {
            Object object2;
            fatBlock = (FatBlock)objArray.get(n3);
            object = nodeArray[fatBlock.realBlock.itsEndNodeIndex];
            int n4 = ((Node)object).getType();
            if (n4 != 5 && n3 < objArray.size() - 1) {
                object2 = (FatBlock)objArray.get(n3 + 1);
                fatBlock.addSuccessor((FatBlock)object2);
                ((FatBlock)object2).addPredecessor(fatBlock);
            }
            if (n4 == 7 || n4 == 6 || n4 == 5) {
                object2 = ((Node.Jump)object).target;
                FatBlock fatBlock3 = (FatBlock)hashMap.get(object2);
                ((Node)object2).putProp(6, fatBlock3.realBlock);
                fatBlock.addSuccessor(fatBlock3);
                fatBlock3.addPredecessor(fatBlock);
            }
            ++n3;
        }
        Block[] blockArray = new Block[objArray.size()];
        int n5 = 0;
        while (n5 < objArray.size()) {
            object = (FatBlock)objArray.get(n5);
            Block block = ((FatBlock)object).realBlock;
            block.itsSuccessors = ((FatBlock)object).getSuccessors();
            block.itsPredecessors = ((FatBlock)object).getPredecessors();
            block.itsBlockID = n5;
            blockArray[n5] = block;
            ++n5;
        }
        return blockArray;
    }

    private static FatBlock newFatBlock(int n, int n2) {
        FatBlock fatBlock = new FatBlock();
        fatBlock.realBlock = new Block(n, n2);
        return fatBlock;
    }

    private static String toString(Block[] blockArray, Node[] nodeArray) {
        return null;
    }

    private static void reachingDefDataFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        int n = 0;
        while (n < blockArray.length) {
            blockArray[n].initLiveOnEntrySets(optFunctionNode, nodeArray);
            ++n;
        }
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n2 = blockArray.length - 1;
        boolean bl = false;
        blArray[n2] = true;
        while (true) {
            if (blArray[n2] || !blArray2[n2]) {
                Block[] blockArray2;
                blArray2[n2] = true;
                blArray[n2] = false;
                if (blockArray[n2].doReachedUseDataFlow() && (blockArray2 = blockArray[n2].itsPredecessors) != null) {
                    int n3 = 0;
                    while (n3 < blockArray2.length) {
                        int n4 = blockArray2[n3].itsBlockID;
                        blArray[n4] = true;
                        bl |= n4 > n2;
                        ++n3;
                    }
                }
            }
            if (n2 == 0) {
                if (!bl) break;
                n2 = blockArray.length - 1;
                bl = false;
                continue;
            }
            --n2;
        }
        blockArray[0].markAnyTypeVariables(nArray);
    }

    private static void typeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = 0;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doTypeFlow(optFunctionNode, nodeArray, nArray) && (blockArray2 = blockArray[n].itsSuccessors) != null) {
                    int n2 = 0;
                    while (n2 < blockArray2.length) {
                        int n3 = blockArray2[n2].itsBlockID;
                        blArray[n3] = true;
                        bl |= n3 < n;
                        ++n2;
                    }
                }
            }
            if (n == blockArray.length - 1) {
                if (!bl) break;
                n = 0;
                bl = false;
                continue;
            }
            ++n;
        }
    }

    private static boolean assignType(int[] nArray, int n, int n2) {
        int n3 = n;
        nArray[n3] = nArray[n3] | n2;
        return n2 != nArray[n3];
    }

    private void markAnyTypeVariables(int[] nArray) {
        int n = 0;
        while (n != nArray.length) {
            if (this.itsLiveOnEntrySet.test(n)) {
                Block.assignType(nArray, n, 3);
            }
            ++n;
        }
    }

    private void lookForVariableAccess(OptFunctionNode optFunctionNode, Node node) {
        switch (node.getType()) {
            case 105: 
            case 106: {
                Node node2 = node.getFirstChild();
                if (node2.getType() != 55) break;
                int n = optFunctionNode.getVarIndex(node2);
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                this.itsNotDefSet.set(n);
                break;
            }
            case 56: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                this.lookForVariableAccess(optFunctionNode, node4);
                this.itsNotDefSet.set(optFunctionNode.getVarIndex(node));
                break;
            }
            case 55: {
                int n = optFunctionNode.getVarIndex(node);
                if (this.itsNotDefSet.test(n)) break;
                this.itsUseBeforeDefSet.set(n);
                break;
            }
            default: {
                Node node5 = node.getFirstChild();
                while (node5 != null) {
                    this.lookForVariableAccess(optFunctionNode, node5);
                    node5 = node5.getNext();
                }
                break block0;
            }
        }
    }

    private void initLiveOnEntrySets(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n = optFunctionNode.getVarCount();
        this.itsUseBeforeDefSet = new DataFlowBitSet(n);
        this.itsNotDefSet = new DataFlowBitSet(n);
        this.itsLiveOnEntrySet = new DataFlowBitSet(n);
        this.itsLiveOnExitSet = new DataFlowBitSet(n);
        int n2 = this.itsStartNodeIndex;
        while (n2 <= this.itsEndNodeIndex) {
            Node node = nodeArray[n2];
            this.lookForVariableAccess(optFunctionNode, node);
            ++n2;
        }
        this.itsNotDefSet.not();
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            int n = 0;
            while (n < this.itsSuccessors.length) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[n].itsLiveOnEntrySet);
                ++n;
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private static int findExpressionType(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        switch (node.getType()) {
            case 40: {
                return 1;
            }
            case 30: 
            case 38: 
            case 70: {
                return 3;
            }
            case 36: {
                return 3;
            }
            case 55: {
                return nArray[optFunctionNode.getVarIndex(node)];
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 105: 
            case 106: {
                return 1;
            }
            case 65: 
            case 66: {
                return 3;
            }
            case 21: {
                Node node2 = node.getFirstChild();
                int n = Block.findExpressionType(optFunctionNode, node2, nArray);
                int n2 = Block.findExpressionType(optFunctionNode, node2.getNext(), nArray);
                return n | n2;
            }
        }
        Node node3 = node.getFirstChild();
        if (node3 == null) {
            return 3;
        }
        int n = 0;
        while (node3 != null) {
            n |= Block.findExpressionType(optFunctionNode, node3, nArray);
            node3 = node3.getNext();
        }
        return n;
    }

    private static boolean findDefPoints(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        switch (node.getType()) {
            default: {
                while (node2 != null) {
                    bl |= Block.findDefPoints(optFunctionNode, node2, nArray);
                    node2 = node2.getNext();
                }
                break;
            }
            case 105: 
            case 106: {
                if (node2.getType() != 55) break;
                int n = optFunctionNode.getVarIndex(node2);
                bl |= Block.assignType(nArray, n, 1);
                break;
            }
            case 35: 
            case 138: {
                if (node2.getType() == 55) {
                    int n = optFunctionNode.getVarIndex(node2);
                    Block.assignType(nArray, n, 3);
                }
                while (node2 != null) {
                    bl |= Block.findDefPoints(optFunctionNode, node2, nArray);
                    node2 = node2.getNext();
                }
                break;
            }
            case 56: {
                Node node3 = node2.getNext();
                int n = Block.findExpressionType(optFunctionNode, node3, nArray);
                int n2 = optFunctionNode.getVarIndex(node);
                bl |= Block.assignType(nArray, n2, n);
            }
        }
        return bl;
    }

    private boolean doTypeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, int[] nArray) {
        boolean bl = false;
        int n = this.itsStartNodeIndex;
        while (n <= this.itsEndNodeIndex) {
            Node node = nodeArray[n];
            if (node != null) {
                bl |= Block.findDefPoints(optFunctionNode, node, nArray);
            }
            ++n;
        }
        return bl;
    }

    private void printLiveOnEntrySet(OptFunctionNode optFunctionNode) {
    }

    private static class FatBlock {
        private ObjToIntMap successors = new ObjToIntMap();
        private ObjToIntMap predecessors = new ObjToIntMap();
        Block realBlock;

        private FatBlock() {
        }

        private static Block[] reduceToArray(ObjToIntMap objToIntMap) {
            Block[] blockArray = null;
            if (!objToIntMap.isEmpty()) {
                blockArray = new Block[objToIntMap.size()];
                int n = 0;
                ObjToIntMap.Iterator iterator = objToIntMap.newIterator();
                iterator.start();
                while (!iterator.done()) {
                    FatBlock fatBlock = (FatBlock)iterator.getKey();
                    blockArray[n++] = fatBlock.realBlock;
                    iterator.next();
                }
            }
            return blockArray;
        }

        void addSuccessor(FatBlock fatBlock) {
            this.successors.put(fatBlock, 0);
        }

        void addPredecessor(FatBlock fatBlock) {
            this.predecessors.put(fatBlock, 0);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }
    }
}

