/* gtd-manager.h
 *
 * Copyright (C) 2015-2020 Georges Basile Stavracas Neto <georges.stavracas@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <gio/gio.h>

#include "gtd-object.h"
#include "gtd-types.h"

G_BEGIN_DECLS

#define GTD_TYPE_MANAGER (gtd_manager_get_type())

G_DECLARE_FINAL_TYPE (GtdManager, gtd_manager, GTD, MANAGER, GtdObject)

/**
 * GtdErrorActionFunc:
 */
typedef void         (*GtdErrorActionFunc)                       (GtdNotification    *notification,
                                                                  gpointer            user_data);


GtdManager*          gtd_manager_new                             (void);

GtdManager*          gtd_manager_get_default                     (void);

GList*               gtd_manager_get_providers                   (GtdManager         *manager);

void                 gtd_manager_add_provider                    (GtdManager         *self,
                                                                  GtdProvider        *provider);

void                 gtd_manager_remove_provider                 (GtdManager         *self,
                                                                  GtdProvider        *provider);

GtdProvider*         gtd_manager_get_default_provider            (GtdManager         *manager);

void                 gtd_manager_set_default_provider            (GtdManager         *manager,
                                                                  GtdProvider        *provider);

GtdTaskList*         gtd_manager_get_inbox                       (GtdManager         *self);

GSettings*           gtd_manager_get_settings                    (GtdManager         *manager);

gboolean             gtd_manager_get_is_first_run                (GtdManager         *manager);

void                 gtd_manager_set_is_first_run                (GtdManager         *manager,
                                                                  gboolean            is_first_run);

void                 gtd_manager_emit_error_message              (GtdManager         *self,
                                                                  const gchar        *title,
                                                                  const gchar        *description,
                                                                  GtdErrorActionFunc  function,
                                                                  gpointer            user_data);

void                 gtd_manager_send_notification               (GtdManager         *self,
                                                                  GtdNotification    *notification);

GtdClock*            gtd_manager_get_clock                       (GtdManager         *self);

GListModel*          gtd_manager_get_task_lists_model            (GtdManager         *self);

GListModel*          gtd_manager_get_all_tasks_model             (GtdManager         *self);

GListModel*          gtd_manager_get_tasks_model                 (GtdManager         *self);

GListModel*          gtd_manager_get_inbox_model                 (GtdManager         *self);

GListModel*          gtd_manager_get_providers_model             (GtdManager         *self);

G_END_DECLS
