/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.ZapResourceBundleControl;
import org.zaproxy.zap.view.ViewLocale;

public final class LocaleUtils {
    private static final Logger logger = LogManager.getLogger(LocaleUtils.class);
    private static final String MESSAGES_BASE_FILENAME = "Messages_";
    private static final String DEFAULT_LOCALE = "en_GB";
    public static final String LANGUAGE_LOCALE_REGEX = "[a-zA-Z]{2,8}";
    public static final String COUNTRY_LOCALE_REGEX = "[a-zA-Z]{2}|[0-9]{3}";

    private LocaleUtils() {
    }

    public static <R> R findResource(String fileName, String fileExtension, Locale locale, Function<String, R> function) {
        return LocaleUtils.findResource(fileName, fileExtension, "", locale, function);
    }

    public static <R> R findResource(ResourceBundle.Control control, String fileName, String fileExtension, Locale locale, Function<String, R> function) {
        return LocaleUtils.findResource(control, fileName, fileExtension, "", locale, function);
    }

    public static <R> R findResource(String fileName, String fileExtension, String localeToken, Locale locale, Function<String, R> function) {
        return LocaleUtils.findResource(new ZapResourceBundleControl(), fileName, fileExtension, localeToken, locale, function);
    }

    public static <R> R findResource(ResourceBundle.Control control, String fileName, String fileExtension, String localeToken, Locale locale, Function<String, R> function) {
        LinkedHashSet<Locale> candidateLocales = new LinkedHashSet<Locale>();
        candidateLocales.addAll(control.getCandidateLocales("", locale));
        Locale fallbackLocale = control.getFallbackLocale("", locale);
        if (fallbackLocale != null) {
            candidateLocales.addAll(control.getCandidateLocales("", fallbackLocale));
        }
        for (Locale candidateLocale : candidateLocales) {
            R result;
            String strLocale = control.toBundleName("", candidateLocale);
            String prefix = fileName;
            if (localeToken != null && !localeToken.isEmpty()) {
                prefix = prefix.replaceAll(Pattern.quote(localeToken), Matcher.quoteReplacement(strLocale));
            }
            if ((result = function.apply(control.toResourceName(prefix + strLocale, fileExtension))) == null) continue;
            return result;
        }
        return null;
    }

    public static Pattern createMessagesPropertiesFilePattern() {
        return LocaleUtils.createResourceFilesPattern("Messages", ".properties");
    }

    public static String createResourceFilesRegex(String fileName, String fileExtension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName must not be null.");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter fileExtension must not be null.");
        }
        StringBuilder strBuilder = new StringBuilder(fileName.length() + LANGUAGE_LOCALE_REGEX.length() + COUNTRY_LOCALE_REGEX.length() + fileExtension.length() + 13);
        strBuilder.append(Pattern.quote(fileName));
        strBuilder.append("(?:_").append(LANGUAGE_LOCALE_REGEX);
        strBuilder.append("(?:_").append(COUNTRY_LOCALE_REGEX).append(")?").append(")?");
        strBuilder.append(Pattern.quote(fileExtension));
        strBuilder.append('$');
        return strBuilder.toString();
    }

    public static Pattern createResourceFilesPattern(String fileName, String fileExtension) {
        return Pattern.compile(LocaleUtils.createResourceFilesRegex(fileName, fileExtension));
    }

    public static List<String> getAvailableLocales() {
        List<String> locales = LocaleUtils.readAvailableLocales();
        Collections.sort(locales);
        locales.add(0, DEFAULT_LOCALE);
        return locales;
    }

    private static List<String> readAvailableLocales() {
        File dir = new File(Constant.getZapInstall(), "lang");
        if (!dir.exists()) {
            logger.debug("Skipping read of available locales, the directory does not exist: " + dir.getAbsolutePath());
            return new ArrayList<String>(0);
        }
        MessagesPropertiesFilenameFilter filter = new MessagesPropertiesFilenameFilter();
        String[] files = dir.list(filter);
        if (files == null || files.length == 0) {
            logger.warn("No Messages files in directory " + dir.getAbsolutePath());
            return new ArrayList<String>(0);
        }
        ArrayList<String> locales = new ArrayList<String>(files.length);
        int baseFilenameLength = MESSAGES_BASE_FILENAME.length();
        for (String file : Arrays.asList(files)) {
            if (!file.startsWith(MESSAGES_BASE_FILENAME)) continue;
            locales.add(file.substring(baseFilenameLength, file.indexOf(".")));
        }
        return locales;
    }

    public static ViewLocale getViewLocale(String locale) {
        return new ViewLocale(locale, LocaleUtils.getLocalDisplayName(locale));
    }

    public static List<ViewLocale> getAvailableViewLocales() {
        List<String> locales = LocaleUtils.readAvailableLocales();
        ArrayList<ViewLocale> localesUI = new ArrayList<ViewLocale>();
        if (!locales.isEmpty()) {
            for (String locale : locales) {
                localesUI.add(new ViewLocale(locale, LocaleUtils.getLocalDisplayName(locale)));
            }
            Collections.sort(localesUI, new Comparator<ViewLocale>(){

                @Override
                public int compare(ViewLocale o1, ViewLocale o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }
        localesUI.add(0, new ViewLocale(DEFAULT_LOCALE, LocaleUtils.getLocalDisplayName(DEFAULT_LOCALE)));
        return localesUI;
    }

    public static String getLocalDisplayName(String locale) {
        String desc = "" + locale;
        if (locale != null) {
            String[] langArray = locale.split("_");
            Locale loc = null;
            if (langArray.length == 1) {
                loc = new Locale(langArray[0]);
            } else if (langArray.length == 2) {
                loc = new Locale(langArray[0], langArray[1]);
            } else if (langArray.length == 3) {
                loc = new Locale(langArray[0], langArray[1], langArray[2]);
            }
            if (loc != null) {
                desc = loc.getDisplayLanguage(loc);
            }
        }
        return desc;
    }

    private static final class MessagesPropertiesFilenameFilter
    implements FilenameFilter {
        private final Pattern messagesPropertiesPattern = LocaleUtils.createMessagesPropertiesFilePattern();

        private MessagesPropertiesFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.messagesPropertiesPattern.matcher(name).matches();
        }
    }
}

