/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.NeighborIndex;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

public class DirectedNeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, NeighborIndex.Neighbors<V, E>> predecessorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    Map<V, NeighborIndex.Neighbors<V, E>> successorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    private DirectedGraph<V, E> graph;

    public DirectedNeighborIndex(DirectedGraph<V, E> g) {
        this.graph = g;
    }

    public Set<V> predecessorsOf(V v) {
        return this.getPredecessors(v).getNeighbors();
    }

    public List<V> predecessorListOf(V v) {
        return this.getPredecessors(v).getNeighborList();
    }

    public Set<V> successorsOf(V v) {
        return this.getSuccessors(v).getNeighbors();
    }

    public List<V> successorListOf(V v) {
        return this.getSuccessors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
        E edge = e.getEdge();
        Object source = this.graph.getEdgeSource(edge);
        Object target = this.graph.getEdgeTarget(edge);
        if (this.successorMap.containsKey(source)) {
            this.getSuccessors(source).addNeighbor(target);
        } else {
            this.getSuccessors(source);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.getPredecessors(target).addNeighbor(source);
        } else {
            this.getPredecessors(target);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
        E edge = e.getEdge();
        V source = e.getEdgeSource();
        V target = e.getEdgeTarget();
        if (this.successorMap.containsKey(source)) {
            this.successorMap.get(source).removeNeighbor(target);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.predecessorMap.get(target).removeNeighbor(source);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e) {
        this.predecessorMap.remove(e.getVertex());
        this.successorMap.remove(e.getVertex());
    }

    private NeighborIndex.Neighbors<V, E> getPredecessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.predecessorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.predecessorListOf(this.graph, v));
            this.predecessorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    private NeighborIndex.Neighbors<V, E> getSuccessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.successorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.successorListOf(this.graph, v));
            this.successorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }
}

