/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.util.HashMap;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.turboproject.PEPUtility;
import net.sf.mpxj.turboproject.Table;

class TableCONTAB
extends Table {
    private static final RelationType[] RELATION_TYPES = new RelationType[]{null, RelationType.START_START, null, RelationType.FINISH_START, RelationType.FINISH_FINISH};

    TableCONTAB() {
    }

    @Override
    protected void readRow(int n, byte[] byArray) {
        if (byArray[0] != -1) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("UNIQUE_ID", n);
            hashMap.put("TASK_ID_1", PEPUtility.getShort(byArray, 1));
            hashMap.put("TASK_ID_2", PEPUtility.getShort(byArray, 3));
            hashMap.put("TYPE", this.getRelationType(PEPUtility.getShort(byArray, 9)));
            hashMap.put("LAG", Duration.getInstance(PEPUtility.getShort(byArray, 11), TimeUnit.DAYS));
            this.addRow(n, hashMap);
        }
    }

    private RelationType getRelationType(int n) {
        RelationType relationType = null;
        if (n >= 0 || n < RELATION_TYPES.length) {
            relationType = RELATION_TYPES[n];
        }
        if (relationType == null) {
            relationType = RelationType.FINISH_START;
        }
        return relationType;
    }
}

