'\"
'\" Generated from file 'tooltip\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1996-2008, Jeffrey Hobbs
'\"
.TH "tooltip" n 1\&.5\&.0 tklib "Tooltip management"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tooltip \- Tooltip management
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBmsgcat  1\&.3\fR
.sp
package require \fBtooltip  ?1\&.4\&.7?\fR
.sp
\fB::tooltip::tooltip\fR \fIcommand\fR ?\fIoptions\fR?
.sp
\fB::tooltip::tooltip\fR \fIpathName\fR ?\fIoption arg\fR? \fImessage\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides tooltips, small text messages that can be displayed
when the mouse hovers over a widget, menu item, canvas item, listbox item
or text widget tag\&.
.SH COMMANDS
.TP
\fB::tooltip::tooltip\fR \fIcommand\fR ?\fIoptions\fR?
Manage the tooltip package using the following subcommands\&.
.RS
.TP
\fBclear\fR ?\fIpattern\fR?
Prevents the specified widgets from showing tooltips\&. \fIpattern\fR
is a glob pattern and defaults to matching all widgets\&.
.TP
\fBconfigure\fR ?\fIopt arg\fR? ?\fIopt arg\fR? ...
Configure foreground, background and font.\&.
.TP
\fBdelay\fR ?\fImillisecs\fR?
Query or set the hover delay\&. This is the interval that the pointer must remain
over the widget before the tooltip is displayed\&. The delay is specified in
milliseconds and must be greater than or equal to 50ms\&.
With no argument the current delay is returned\&.
.TP
\fBfade\fR ?\fIboolean\fR?
Enable or disable fading of the tooltip\&.  The fading is enabled by default on
Win32 and Aqua\&.  The tooltip will fade away on Leave events instead
disappearing\&.
.TP
\fBdisable\fR
.TP
\fBoff\fR
Disable all tooltips
.TP
\fBenable\fR
.TP
\fBon\fR
Enables tooltips for defined widgets\&.
.RE
.sp
.TP
\fB::tooltip::tooltip\fR \fIpathName\fR ?\fIoption arg\fR? \fImessage\fR
This command arranges for widget \fIpathName\fR to display a tooltip with
message \fImessage\fR\&.  The tooltip uses a late-binding msgcat call on the
passed in message to allow for on-the-fly language changes in an application\&.
If the widget specified is a menu, canvas, listbox or text widget then
additional options are used to tie the tooltip to specific menu entries,
canvas or listbox items, or text widget tags\&.
.RS
.TP
\fB-index\fR \fIindex\fR
This option is used to set a tooltip on a menu item\&. The index may be
either the entry index or the entry label\&. The widget must be a menu
widget but the entries do not have to exist when the tooltip is set\&.
.TP
\fB-items\fR \fIname\fR
This option is used to set a tooltip for canvas widget or listbox items\&.
For the canvas widget, the item must already be present in the canvas
widget and will be found with a \fBfind withtag\fR lookup\&.
For listbox widgets the item(s) may be created later but the programmer
is responsible for managing the link between the listbox item index and the
corresponding tooltip\&. If the listbox items are re-ordered, the tooltips
will need amending\&.
.sp
If the widget is not a canvas or listbox then an error is raised\&.
.TP
\fB-tag\fR \fIname\fR
The \fB-tag\fR option can be used to set a tooltip for a text widget
tag\&. The tag should already be present when this command is called or
an error will be returned\&. The widget must also be a text widget\&.
.TP
\fB--\fR
The \fB--\fR option marks the end of options\&.
The argument following this one will be treated as \fImessage\fR even if it starts with a -\&.
.RE
.PP
.SH EXAMPLE
.CS


# Demonstrate widget tooltip
package require tooltip
pack [label \&.l -text "label"]
tooltip::tooltip \&.l "This is a label widget"

.CE
.CS


# Demonstrate menu tooltip
package require tooltip
\&. configure -menu [menu \&.menu]
\&.menu add cascade -label Test -menu [menu \&.menu\&.test -tearoff 0]
\&.menu\&.test add command -label Tooltip
tooltip::tooltip \&.menu\&.test -index 0 "This is a menu tooltip"

.CE
.CS


# Demonstrate canvas item tooltip
package require tooltip
pack [canvas \&.c]
set item [\&.c create rectangle 10 10 80 80 -fill red]
tooltip::tooltip \&.c -item $item "Canvas item tooltip"

.CE
.CS


# Demonstrate listbox item tooltip
package require tooltip
pack [listbox \&.lb]
\&.lb insert 0 "item one"
tooltip::tooltip \&.lb -item 0 "Listbox item tooltip"

.CE
.CS


# Demonstrate text tag tooltip
package require tooltip
pack [text \&.txt]
\&.txt tag configure TIP-1 -underline 1
tooltip::tooltip \&.txt -tag TIP-1 "tooltip one text"
\&.txt insert end "An example of a " {} "tooltip" TIP-1 " tag\&.\\n" {}

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItooltip\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
balloon, help, hover, tooltip
.SH COPYRIGHT
.nf
Copyright (c) 1996-2008, Jeffrey Hobbs

.fi
