/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.FontException;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeCollection;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontRecord;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TrueTypeFontRegistry
extends AbstractFontFileRegistry {
    private static FontCache secondLevelCache;
    private static final Logger logger;
    private static final FontPathFilter FONTPATHFILTER;
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    @Override
    public FontCache getSecondLevelCache() {
        return TrueTypeFontRegistry.internalGetSecondLevelCache();
    }

    @Override
    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addFont(File file, String encoding) throws IOException {
        try {
            if (StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                int i = 0;
                while ((long)i < ttc.getNumFonts()) {
                    TrueTypeFont font = null;
                    try {
                        font = ttc.getFont(i);
                        this.registerTrueTypeFont(font);
                    }
                    finally {
                        if (font != null) {
                            font.dispose();
                        }
                    }
                    ++i;
                }
            } else {
                TrueTypeFont font = null;
                try {
                    font = new TrueTypeFont(file);
                    this.registerTrueTypeFont(font);
                }
                finally {
                    if (font != null) {
                        font.dispose();
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.info("Unable to register font file " + file + " : " + e);
            return false;
        }
    }

    private void registerTrueTypeFont(TrueTypeFont font) throws IOException {
        NameTable table = (NameTable)font.getTable(1851878757L);
        if (table == null) {
            throw new IOException("The NameTable is required for all conforming fonts.");
        }
        String familyName = table.getPrimaryName(1);
        DefaultFontFamily fontFamily = this.createFamily(familyName);
        try {
            TrueTypeFontRecord record = new TrueTypeFontRecord(font, fontFamily);
            fontFamily.addFontRecord(record);
        }
        catch (FontException e) {
            logger.info("The font '" + font.getFilename() + "' is invalid: " + (Object)((Object)e));
            return;
        }
        this.fontFamilies.put(familyName, fontFamily);
        this.alternateFamilyNames.put(familyName, fontFamily);
        for (String name : table.getAllNames(1)) {
            fontFamily.addName(name);
            this.alternateFamilyNames.put(name, fontFamily);
        }
        for (String name : table.getAllNames(4)) {
            this.fullFontNames.put(name, fontFamily);
        }
    }

    private DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = (DefaultFontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        return new DefaultFontFamily(name);
    }

    @Override
    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    @Override
    public FontFamily getFontFamily(String name) {
        FontFamily primary = (FontFamily)this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = (FontFamily)this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return (FontFamily)this.fullFontNames.get(name);
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        return new TrueTypeFontMetricsFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFromCache(String encoding) {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        File ttfCache = new File(location, "ttf-fontcache.ser");
        try {
            HashMap cachedAlternateNames;
            HashMap cachedFullFontNames;
            HashMap cachedFontFamilies;
            HashMap cachedSeenFiles;
            ResourceKey resourceKey = resourceManager.createKey((Object)ttfCache);
            ResourceData data = resourceManager.load(resourceKey);
            try (InputStream stream = data.getResourceAsStream(resourceManager);){
                ObjectInputStream oin = new ObjectInputStream(stream);
                Object[] cache = (Object[])oin.readObject();
                if (cache.length != 5) {
                    return;
                }
                if (!ObjectUtilities.equal((Object)encoding, (Object)cache[0])) {
                    return;
                }
                cachedSeenFiles = (HashMap)cache[1];
                cachedFontFamilies = (HashMap)cache[2];
                cachedFullFontNames = (HashMap)cache[3];
                cachedAlternateNames = (HashMap)cache[4];
            }
            if (this.isCacheValid(cachedSeenFiles)) {
                this.getSeenFiles().putAll(cachedSeenFiles);
                this.fontFamilies.putAll(cachedFontFamilies);
                this.fullFontNames.putAll(cachedFullFontNames);
                this.alternateFamilyNames.putAll(cachedAlternateNames);
            }
        }
        catch (ClassNotFoundException cnfe) {
            logger.config("Failed to restore the cache: Cache was created by a different version of LibFonts");
        }
        catch (Exception e) {
            logger.config("Non-Fatal: Failed to restore the cache. The cache will be rebuilt: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeToCache(String encoding) {
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        location.mkdirs();
        if (!location.exists() || !location.isDirectory()) {
            return;
        }
        File ttfCache = new File(location, "ttf-fontcache.ser");
        try {
            FileOutputStream fout = new FileOutputStream(ttfCache);
            try {
                Object[] map = new Object[]{encoding, this.getSeenFiles(), this.fontFamilies, this.fullFontNames, this.alternateFamilyNames};
                ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fout));
                objectOut.writeObject(map);
                objectOut.close();
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    logger.config("Failed to store cached font data: " + e);
                }
            }
        }
        catch (IOException e) {
            logger.config("Failed to store cached font data: " + e);
        }
    }

    static {
        logger = Logger.getLogger(TrueTypeFontRegistry.class.getName());
        FONTPATHFILTER = new FontPathFilter();
    }

    private static class FontPathFilter
    implements FileFilter,
    Serializable {
        protected FontPathFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttf")) {
                return true;
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttc")) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase((String)name, (String)".otf");
        }
    }
}

