"""Generated message classes for backupdr version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'backupdr'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BackupPlan(_messages.Message):
  r"""A `BackupPlan` specifies some common fields, such as `display_name` as
  well as one or more `BackupRule` messages. Each `BackupRule` has a retention
  policy and defines a schedule by which the system is to perform backup
  workloads.

  Enums:
    StateValueValuesEnum: Output only. The `State` for the `BackupPlan`.

  Messages:
    LabelsValue: Optional. This collection of key/value pairs allows for
      custom labels to be supplied by the user. Example, {"tag": "Weekly"}.

  Fields:
    adminScope: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The resource name of AdminScope
      with which this `BackupPlan` is associated. Format :
      projects/{project}/locations/{region}/adminScopes/{admin_scope}
    backupRules: Required. The backup rules for this `BackupPlan`. There must
      be at least one `BackupRule` message.
    createTime: Output only. When the `BackupPlan` was created.
    description: Optional. The description of the `BackupPlan` resource. The
      description allows for additional details about `BackupPlan` and its use
      cases to be provided. An example description is the following: "This is
      a backup plan that performs a daily backup at 6pm and retains data for 3
      months". The description must be at most 2048 characters.
    displayName: Required. The display name of the `BackupPlan`. This human-
      readable name must start with a lowercase letter followed by up to 62
      lowercase letters, numbers, or hyphens. Pattern, /a-z{,62}/.
    etag: Optional. `etag` is returned from the service in the response. As a
      user of the service, you may provide an etag value in this field to
      prevent stale resources.
    labels: Optional. This collection of key/value pairs allows for custom
      labels to be supplied by the user. Example, {"tag": "Weekly"}.
    name: Output only. The resource name of the `BackupPlan`. Format:
      `projects/{project}/locations/{region}/backupPlans/{backup_plan}`
    resourceType: Required. The resource type to which the `BackupPlan` will
      be applied. Examples include, "compute.googleapis.com/Instance" and
      "storage.googleapis.com/Bucket".
    state: Output only. The `State` for the `BackupPlan`.
    updateTime: Output only. When the `BackupPlan` was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The `State` for the `BackupPlan`.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The resource is being created.
      ACTIVE: The resource has been created and is fully usable.
      DELETING: The resource is being deleted.
      READY: TODO b/325560313: Deprecated and field will be removed after UI
        integration change. The resource has been created.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    READY = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. This collection of key/value pairs allows for custom labels
    to be supplied by the user. Example, {"tag": "Weekly"}.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminScope = _messages.StringField(1)
  backupRules = _messages.MessageField('BackupRule', 2, repeated=True)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  resourceType = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class BackupPlanAssociation(_messages.Message):
  r"""A BackupPlanAssociation represents a single BackupPlanAssociation which
  contains details like workload, backup plan etc

  Enums:
    StateValueValuesEnum: Output only. The BackupPlanAssociation resource
      state.

  Fields:
    backupCollectionId: Output only. TODO b/325560313: Deprecated and field
      will be removed after UI integration change. Output only. This will
      return the relative url of the AGM application object which will be used
      to redirect to AGM UI from the pantheon to show a list of backups.
    backupPlan: Required. Resource name of backup plan which needs to be
      applied on workload. Format:
      projects/{project}/locations/{region}/backupPlans/{backupPlanId}
    createTime: Output only. The time when the instance was created.
    name: Output only. The resource name of BackupPlanAssociation in below
      format Format : projects/{project}/locations/{region}/backupPlanAssociat
      ions/{backupPlanAssociationId}
    resource: Required. Immutable. Resource name of workload on which
      backupplan is applied
    resourceType: Required. Immutable. Resource type of workload on which
      backupplan is applied
    rulesConfigInfo: Output only. The config info related to backup rules.
    scopeId: Output only. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. This will return the scope with
      which this backup plan association is associated with.
    state: Output only. The BackupPlanAssociation resource state.
    updateTime: Output only. The time when the instance was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The BackupPlanAssociation resource state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The resource is being created.
      ACTIVE: The resource has been created and is fully usable.
      DELETING: The resource is being deleted.
      READY: TODO b/325560313: Deprecated and field will be removed after UI
        integration change. The resource has been created and is fully usable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    READY = 4

  backupCollectionId = _messages.StringField(1)
  backupPlan = _messages.StringField(2)
  createTime = _messages.StringField(3)
  name = _messages.StringField(4)
  resource = _messages.StringField(5)
  resourceType = _messages.StringField(6)
  rulesConfigInfo = _messages.MessageField('RuleConfigInfo', 7, repeated=True)
  scopeId = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class BackupRule(_messages.Message):
  r"""`BackupRule` binds the backup schedule to a retention policy.

  Fields:
    backupRetentionDays: Required. Configures the duration for which backup
      data will be kept. It is defined in "days". The value should be greater
      than or equal to minimum enforced retention of the backup vault.
    backupVault: Required. Resource name of backup vault which will be used as
      storage location for backups. Format:
      projects/{project}/locations/{location}/backupVaults/{backupvault}
    backupVaultServiceAccount: Output only. The Google Cloud Platform Service
      Account to be used by the BackupVault for taking backups. Specify the
      email address of the Backup Vault Service Account. (precedent: https://s
      ource.corp.google.com/piper///depot/google3/google/container/v1/cluster_
      service.proto;l=1014-1019)
    displayName: Optional. The display name of the `BackupRule`.
    ruleId: Output only. The unique id of this `BackupRule`. The `rule_id` is
      unique per `BackupPlan`.
    standardSchedule: Required. Defines a schedule that runs within the
      confines of a defined window of time.
  """

  backupRetentionDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backupVault = _messages.StringField(2)
  backupVaultServiceAccount = _messages.StringField(3)
  displayName = _messages.StringField(4)
  ruleId = _messages.StringField(5)
  standardSchedule = _messages.MessageField('StandardSchedule', 6)


class BackupWindow(_messages.Message):
  r"""`BackupWindow` defines a window of the day during which backup jobs will
  run.

  Fields:
    endHourOfDay: Required. The hour of day (1-24) when the window end for
      e.g. if value of end hour of day is 10 that mean backup window end time
      is 10:00. End hour of day should be greater than start hour of day. 0 <=
      start_hour_of_day < end_ hour_of_day <= 24 End hour of day is not
      include in backup window that mean if end_hour_of_day= 10 jobs should
      start before 10:00.
    endTime: Optional. TODO b/325560313: Deprecated and field will be removed
      after UI integration change. The end time of the window in which to pick
      backup jobs to run.
    startHourOfDay: Required. The hour of day (0-23) when the window starts
      for e.g. if value of start hour of day is 6 that mean backup window
      start at 6:00.
    startTime: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The start time of the window in
      which to pick backup jobs to run.
  """

  endHourOfDay = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  endTime = _messages.MessageField('TimeOfDay', 2)
  startHourOfDay = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.MessageField('TimeOfDay', 4)


class BackupdrProjectsLocationsBackupPlanAssociationsCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsCreateRequest object.

  Fields:
    backupPlanAssociation: A BackupPlanAssociation resource to be passed as
      the request body.
    backupPlanAssociationId: Required. The name of the backup plan association
      to create. The name must be unique for the specified project and
      location.
    parent: Required. The backup plan association project and location in the
      format `projects/{project_id}/locations/{location}`. In Cloud BackupDR
      locations map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backupPlanAssociation = _messages.MessageField('BackupPlanAssociation', 1)
  backupPlanAssociationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsBackupPlanAssociationsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsBackupPlanAssociationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsGetRequest object.

  Fields:
    name: Required. Name of the backup plan association resource, in the
      format `projects/{project_id}/locations/{location}/backupPlanAssociation
      s/{resource_name}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupPlanAssociationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsListRequest object.

  Fields:
    filter: Optional. Filtering results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve backup
      Plan Associations information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud BackupDR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      backup plan associations for all locations, use "-" for the `{location}`
      value.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BackupdrProjectsLocationsBackupPlansCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansCreateRequest object.

  Fields:
    backupPlan: A BackupPlan resource to be passed as the request body.
    backupPlanId: Required. The name of the `BackupPlan` to create. The name
      must be unique for the specified project and location.The name must
      start with a lowercase letter followed by up to 62 lowercase letters,
      numbers, or hyphens. Pattern, /a-z{,62}/.
    parent: Required. The `BackupPlan` project and location in the format
      `projects/{project}/locations/{location}`. In Cloud BackupDR locations
      map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backupPlan = _messages.MessageField('BackupPlan', 1)
  backupPlanId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsBackupPlansDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansDeleteRequest object.

  Fields:
    name: Required. The resource name of the `BackupPlan` to delete. Format:
      `projects/{project}/locations/{region}/backupPlans/{backup_plan}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsBackupPlansGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansGetRequest object.

  Fields:
    name: Required. The resource name of the `BackupPlan` to retrieve. Format:
      `projects/{project}/locations/{region}/backupPlans/{backup_plan}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupPlansListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansListRequest object.

  Fields:
    filter: Optional. Field match expression used to filter the results.
    orderBy: Optional. Field by which to sort the results.
    pageSize: Optional. The maximum number of `BackupPlans` to return in a
      single response. If not specified, a default value will be chosen by the
      service. Note that the response may include a partial list and a caller
      should only rely on the response's next_page_token to determine if there
      are more instances left to be queried.
    pageToken: Optional. The value of next_page_token received from a previous
      `ListBackupPlans` call. Provide this to retrieve the subsequent page in
      a multi-page list of results. When paginating, all other parameters
      provided to `ListBackupPlans` must match the call that provided the page
      token.
    parent: Required. The project and location for which to retrieve
      `BackupPlans` information. Format:
      `projects/{project}/locations/{region}`. In Cloud BackupDR, locations
      map to GCP regions, for e.g. **us-central1**. To retrieve backup plans
      for all locations, use "-" for the `{region}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsBackupVaultsTestIamPermissionsRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BackupdrProjectsLocationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BackupdrProjectsLocationsManagementServersCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersCreateRequest object.

  Fields:
    managementServer: A ManagementServer resource to be passed as the request
      body.
    managementServerId: Required. The name of the management server to create.
      The name must be unique for the specified project and location.
    parent: Required. The management server project and location in the format
      `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
      locations map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  managementServer = _messages.MessageField('ManagementServer', 1)
  managementServerId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsManagementServersDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsManagementServersGetIamPolicyRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BackupdrProjectsLocationsManagementServersGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersGetRequest object.

  Fields:
    name: Required. Name of the management server resource name, in the format
      `projects/{project_id}/locations/{location}/managementServers/{resource_
      name}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsManagementServersListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve
      management servers information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud BackupDR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      management servers for all locations, use "-" for the `{location}`
      value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsManagementServersSetIamPolicyRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BackupdrProjectsLocationsManagementServersTestIamPermissionsRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BackupdrProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class BackupdrProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ListBackupPlanAssociationsResponse(_messages.Message):
  r"""Response message for List BackupPlanAssociation

  Fields:
    backupPlanAssociations: The list of Backup Plan Associations in the
      project for the specified location. If the `{location}` value in the
      request is "-", the response contains a list of instances from all
      locations. In case any location is unreachable, the response will only
      return backup plan associations in reachable locations and the
      'unreachable' field will be populated with a list of unreachable
      locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backupPlanAssociations = _messages.MessageField('BackupPlanAssociation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupPlansResponse(_messages.Message):
  r"""The response message for getting a list of `BackupPlan`.

  Fields:
    backupPlans: The list of `BackupPlans` in the project for the specified
      location. If the `{location}` value in the request is "-", the response
      contains a list of resources from all locations. In case any location is
      unreachable, the response will only return backup plans in reachable
      locations and the 'unreachable' field will be populated with a list of
      unreachable locations. BackupPlan
    nextPageToken: A token which may be sent as page_token in a subsequent
      `ListBackupPlans` call to retrieve the next page of results. If this
      field is omitted or empty, then there are no more results to return.
    unreachable: Locations that could not be reached.
  """

  backupPlans = _messages.MessageField('BackupPlan', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListManagementServersResponse(_messages.Message):
  r"""Response message for listing management servers.

  Fields:
    managementServers: The list of ManagementServer instances in the project
      for the specified location. If the `{location}` value in the request is
      "-", the response contains a list of instances from all locations. In
      case any location is unreachable, the response will only return
      management servers in reachable locations and the 'unreachable' field
      will be populated with a list of unreachable locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  managementServers = _messages.MessageField('ManagementServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagementServer(_messages.Message):
  r"""ManagementServer describes a single BackupDR ManagementServer instance.

  Enums:
    StateValueValuesEnum: Output only. The ManagementServer state.
    TypeValueValuesEnum: Optional. The type of the ManagementServer resource.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Labels currently defined: 1. migrate_from_go= If set to true,
      the MS is created in migration ready mode.

  Fields:
    createTime: Output only. The time when the instance was created.
    description: Optional. The description of the ManagementServer instance
      (2048 characters or less).
    etag: Optional. Server specified ETag for the ManagementServer resource to
      prevent simultaneous updates from overwiting each other.
    labels: Optional. Resource labels to represent user provided metadata.
      Labels currently defined: 1. migrate_from_go= If set to true, the MS is
      created in migration ready mode.
    managementUri: Output only. The hostname or ip address of the exposed AGM
      endpoints, used by clients to connect to AGM/RD graphical user interface
      and APIs.
    name: Output only. Identifier. The resource name.
    networks: Required. VPC networks to which the ManagementServer instance is
      connected. For this version, only a single network is supported.
    oauth2ClientId: Output only. The OAuth 2.0 client id is required to make
      API calls to the BackupDR instance API of this ManagementServer. This is
      the value that should be provided in the 'aud' field of the OIDC ID
      Token (see openid specification https://openid.net/specs/openid-connect-
      core-1_0.html#IDToken).
    state: Output only. The ManagementServer state.
    type: Optional. The type of the ManagementServer resource.
    updateTime: Output only. The time when the instance was updated.
    workforceIdentityBasedManagementUri: Output only. The hostnames of the
      exposed AGM endpoints for both types of user i.e. 1p and 3p, used to
      connect AGM/RM UI.
    workforceIdentityBasedOauth2ClientId: Output only. The OAuth client IDs
      for both types of user i.e. 1p and 3p.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The ManagementServer state.

    Values:
      INSTANCE_STATE_UNSPECIFIED: State not set.
      CREATING: The instance is being created.
      READY: The instance has been created and is fully usable.
      UPDATING: The instance configuration is being updated. Certain kinds of
        updates may cause the instance to become unusable while the update is
        in progress.
      DELETING: The instance is being deleted.
      REPAIRING: The instance is being repaired and may be unstable.
      MAINTENANCE: Maintenance is being performed on this instance.
      ERROR: The instance is experiencing an issue and might be unusable. You
        can get further details from the statusMessage field of Instance
        resource.
    """
    INSTANCE_STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    REPAIRING = 5
    MAINTENANCE = 6
    ERROR = 7

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the ManagementServer resource.

    Values:
      INSTANCE_TYPE_UNSPECIFIED: Instance type is not mentioned.
      BACKUP_RESTORE: Instance for backup and restore management (i.e., AGM).
    """
    INSTANCE_TYPE_UNSPECIFIED = 0
    BACKUP_RESTORE = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Labels
    currently defined: 1. migrate_from_go= If set to true, the MS is created
    in migration ready mode.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  managementUri = _messages.MessageField('ManagementURI', 5)
  name = _messages.StringField(6)
  networks = _messages.MessageField('NetworkConfig', 7, repeated=True)
  oauth2ClientId = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)
  workforceIdentityBasedManagementUri = _messages.MessageField('WorkforceIdentityBasedManagementURI', 12)
  workforceIdentityBasedOauth2ClientId = _messages.MessageField('WorkforceIdentityBasedOAuth2ClientID', 13)


class ManagementURI(_messages.Message):
  r"""ManagementURI for the Management Server resource.

  Fields:
    api: Output only. The ManagementServer AGM/RD API URL.
    webUi: Output only. The ManagementServer AGM/RD WebUI URL.
  """

  api = _messages.StringField(1)
  webUi = _messages.StringField(2)


class NetworkConfig(_messages.Message):
  r"""Network configuration for ManagementServer instance.

  Enums:
    PeeringModeValueValuesEnum: Optional. The network connect mode of the
      ManagementServer instance. For this version, only PRIVATE_SERVICE_ACCESS
      is supported.

  Fields:
    network: Optional. The resource name of the Google Compute Engine VPC
      network to which the ManagementServer instance is connected.
    peeringMode: Optional. The network connect mode of the ManagementServer
      instance. For this version, only PRIVATE_SERVICE_ACCESS is supported.
  """

  class PeeringModeValueValuesEnum(_messages.Enum):
    r"""Optional. The network connect mode of the ManagementServer instance.
    For this version, only PRIVATE_SERVICE_ACCESS is supported.

    Values:
      PEERING_MODE_UNSPECIFIED: Peering mode not set.
      PRIVATE_SERVICE_ACCESS: Connect using Private Service Access to the
        Management Server. Private services access provides an IP address
        range for multiple Google Cloud services, including Cloud BackupDR.
    """
    PEERING_MODE_UNSPECIFIED = 0
    PRIVATE_SERVICE_ACCESS = 1

  network = _messages.StringField(1)
  peeringMode = _messages.EnumField('PeeringModeValueValuesEnum', 2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Messages:
    AdditionalInfoValue: Output only. AdditionalInfo contains additional Info
      related to backup plan association resource.

  Fields:
    additionalInfo: Output only. AdditionalInfo contains additional Info
      related to backup plan association resource.
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalInfoValue(_messages.Message):
    r"""Output only. AdditionalInfo contains additional Info related to backup
    plan association resource.

    Messages:
      AdditionalProperty: An additional property for a AdditionalInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type AdditionalInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalInfo = _messages.MessageField('AdditionalInfoValue', 1)
  apiVersion = _messages.StringField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RuleConfigInfo(_messages.Message):
  r"""Message for rules config info.

  Enums:
    StateValueValuesEnum: Output only. The config state for rule.

  Fields:
    dataSource: Output only. Output Only. Resource name of data source which
      will be used as storage location for backups taken by specified rule.
      Format : projects/{project}/locations/{location}/backupVaults/{backupvau
      lt}/dataSources/{datasource}
    lastSuccessfulBackupConsistencyTime: Output only. The point in time when
      the last successful backup was captured from the source.
    ruleDisplayName: Output only. Output Only. Backup Rule id fetched from
      backup plan.
    ruleId: Output only. Output Only. Backup Rule id fetched from backup plan.
    state: Output only. The config state for rule.
    stateDetails: Output only. Output Only. Additional details for current
      config state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The config state for rule.

    Values:
      CONFIG_STATE_UNSPECIFIED: State not set.
      FIRST_BACKUP_PENDING: The first backup is pending.
      PERMISSIONS_MISSING: Required permissions are missing to perform backup
        operation.
      LAST_BACKUP_SUCCEEDED: The last backup operation succeeded.
      LAST_BACKUP_FAILED: The last backup operation failed.
    """
    CONFIG_STATE_UNSPECIFIED = 0
    FIRST_BACKUP_PENDING = 1
    PERMISSIONS_MISSING = 2
    LAST_BACKUP_SUCCEEDED = 3
    LAST_BACKUP_FAILED = 4

  dataSource = _messages.StringField(1)
  lastSuccessfulBackupConsistencyTime = _messages.StringField(2)
  ruleDisplayName = _messages.StringField(3)
  ruleId = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  stateDetails = _messages.StringField(6)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StandardSchedule(_messages.Message):
  r"""`StandardSchedule` defines a schedule that run within the confines of a
  defined window of days. We can define recurrence type for schedule as
  HOURLY, DAILY, WEEKLY, MONTHLY or YEARLY.

  Enums:
    DaysOfWeekValueListEntryValuesEnum:
    MonthsValueListEntryValuesEnum:
    RecurrenceTypeValueValuesEnum: Required. Specifies the `RecurrenceType`
      for the schedule.

  Fields:
    backupWindow: Required. A BackupWindow defines the window of day during
      which backup jobs will run. Jobs are queued at the beginning of the
      window and will be marked as `NOT_RUN` if they do not start by the end
      of the window. Note: running jobs will not be cancelled at the end of
      the window.
    daysOfMonth: Optional. Specifies days of months like 1, 5, or 14 on which
      jobs will run. Values for `days_of_month` are only applicable for
      `recurrence_type`, `MONTHLY` and `YEARLY`. A validation error will occur
      if other values are supplied.
    daysOfWeek: Optional. Specifies days of week like, MONDAY or TUESDAY, on
      which jobs will run. This is required for `recurrence_type`, `WEEKLY`
      and is not applicable otherwise. A validation error will occur if a
      value is supplied and `recurrence_type` is not `WEEKLY`.
    hourlyFrequency: Optional. Specifies frequency for hourly backups. A
      hourly frequency of 2 means jobs will run every 2 hours from start time
      till end time defined. This is required for `recurrence_type`, `HOURLY`
      and is not applicable otherwise. A validation error will occur if a
      value is supplied and `recurrence_type` is not `HOURLY`. Value of hourly
      frequency should be between 6 and 23. Reason for limit : We found that
      there is bandwidth limitation of 3GB/S for GMI while taking a backup and
      5GB/S while doing a restore. Given the amount of parallel backups and
      restore we are targeting, this will potentially take the backup time to
      mins and hours (in worst case scenario).
    months: Optional. Specifies the months of year, like `FEBRUARY` and/or
      `MAY`, on which jobs will run. This field is only applicable when
      `recurrence_type` is `YEARLY`. A validation error will occur if other
      values are supplied.
    recurrenceType: Required. Specifies the `RecurrenceType` for the schedule.
    repeatInterval: Required. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. Repeat interval
    timeZone: Optional. This will be supported in GA not in PP. The time zone
      to be used when interpreting the schedule. The value of this field must
      be a time zone name from the IANA tz database. See
      https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
      list of valid timezone names. The default value is UTC. For e.g.,
      Europe/Paris.
    weekDayOfMonth: Optional. This will be supported in GA not in PP.
      Specifies a week day of the month like, FIRST SUNDAY or LAST MONDAY, on
      which jobs will run. This will be specified by two fields in
      `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
      e.g. `LAST`. This field is only applicable for `recurrence_type`,
      `MONTHLY` and `YEARLY`. A validation error will occur if other values
      are supplied.
  """

  class DaysOfWeekValueListEntryValuesEnum(_messages.Enum):
    r"""DaysOfWeekValueListEntryValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class MonthsValueListEntryValuesEnum(_messages.Enum):
    r"""MonthsValueListEntryValuesEnum enum type.

    Values:
      MONTH_UNSPECIFIED: The unspecified month.
      JANUARY: The month of January.
      FEBRUARY: The month of February.
      MARCH: The month of March.
      APRIL: The month of April.
      MAY: The month of May.
      JUNE: The month of June.
      JULY: The month of July.
      AUGUST: The month of August.
      SEPTEMBER: The month of September.
      OCTOBER: The month of October.
      NOVEMBER: The month of November.
      DECEMBER: The month of December.
    """
    MONTH_UNSPECIFIED = 0
    JANUARY = 1
    FEBRUARY = 2
    MARCH = 3
    APRIL = 4
    MAY = 5
    JUNE = 6
    JULY = 7
    AUGUST = 8
    SEPTEMBER = 9
    OCTOBER = 10
    NOVEMBER = 11
    DECEMBER = 12

  class RecurrenceTypeValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the `RecurrenceType` for the schedule.

    Values:
      RECURRENCE_TYPE_UNSPECIFIED: recurrence type not set
      HOURLY: The `BackupRule` is to be applied hourly.
      DAILY: The `BackupRule` is to be applied daily.
      WEEKLY: The `BackupRule` is to be applied weekly.
      MONTHLY: The `BackupRule` is to be applied monthly.
      YEARLY: The `BackupRule` is to be applied yearly.
    """
    RECURRENCE_TYPE_UNSPECIFIED = 0
    HOURLY = 1
    DAILY = 2
    WEEKLY = 3
    MONTHLY = 4
    YEARLY = 5

  backupWindow = _messages.MessageField('BackupWindow', 1)
  daysOfMonth = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.INT32)
  daysOfWeek = _messages.EnumField('DaysOfWeekValueListEntryValuesEnum', 3, repeated=True)
  hourlyFrequency = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  months = _messages.EnumField('MonthsValueListEntryValuesEnum', 5, repeated=True)
  recurrenceType = _messages.EnumField('RecurrenceTypeValueValuesEnum', 6)
  repeatInterval = _messages.IntegerField(7)
  timeZone = _messages.StringField(8)
  weekDayOfMonth = _messages.MessageField('WeekDayOfMonth', 9)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class WeekDayOfMonth(_messages.Message):
  r"""`WeekDayOfMonth` defines the week day of the month on which the backups
  will run. The message combines a `WeekOfMonth` and `DayOfWeek` to produce
  values like `FIRST`/`MONDAY` or `LAST`/`FRIDAY`.

  Enums:
    DayOfWeekValueValuesEnum: Required. Specifies the day of the week.
    WeekOfMonthValueValuesEnum: Required. Specifies the week of the month.

  Fields:
    dayOfWeek: Required. Specifies the day of the week.
    weekOfMonth: Required. Specifies the week of the month.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class WeekOfMonthValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the week of the month.

    Values:
      WEEK_OF_MONTH_UNSPECIFIED: The zero value. Do not use.
      FIRST: The first week of the month.
      SECOND: The second week of the month.
      THIRD: The third week of the month.
      FOURTH: The fourth week of the month.
      LAST: The last week of the month.
    """
    WEEK_OF_MONTH_UNSPECIFIED = 0
    FIRST = 1
    SECOND = 2
    THIRD = 3
    FOURTH = 4
    LAST = 5

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  weekOfMonth = _messages.EnumField('WeekOfMonthValueValuesEnum', 2)


class WorkforceIdentityBasedManagementURI(_messages.Message):
  r"""ManagementURI depending on the Workforce Identity i.e. either 1p or 3p.

  Fields:
    firstPartyManagementUri: Output only. First party Management URI for
      Google Identities.
    thirdPartyManagementUri: Output only. Third party Management URI for
      External Identity Providers.
  """

  firstPartyManagementUri = _messages.StringField(1)
  thirdPartyManagementUri = _messages.StringField(2)


class WorkforceIdentityBasedOAuth2ClientID(_messages.Message):
  r"""OAuth Client ID depending on the Workforce Identity i.e. either 1p or
  3p,

  Fields:
    firstPartyOauth2ClientId: Output only. First party OAuth Client ID for
      Google Identities.
    thirdPartyOauth2ClientId: Output only. Third party OAuth Client ID for
      External Identity Providers.
  """

  firstPartyOauth2ClientId = _messages.StringField(1)
  thirdPartyOauth2ClientId = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
