/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMemoryBackend;

@RrdBackendAnnotation(name="MEMORY", shouldValidateHeader=false)
public class RrdMemoryBackendFactory
extends RrdBackendFactory {
    protected final Map<String, AtomicReference<ByteBuffer>> backends = new ConcurrentHashMap<String, AtomicReference<ByteBuffer>>();

    @Override
    protected RrdBackend open(String id, boolean readOnly) throws IOException {
        AtomicReference refbb = this.backends.computeIfAbsent(id, i -> new AtomicReference());
        return new RrdMemoryBackend(id, refbb);
    }

    @Override
    public boolean canStore(URI uri) {
        return uri.getScheme().equals(this.getScheme());
    }

    @Override
    protected boolean exists(String id) {
        return this.backends.containsKey(id);
    }

    public boolean delete(String id) {
        if (this.backends.containsKey(id)) {
            this.backends.remove(id);
            return true;
        }
        return false;
    }
}

