/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class ShellCommand {
    private static final boolean CONSUME_OUTPUT = true;
    private static final boolean NO_CONSUME_OUTPUT = false;
    private static final boolean WAIT_FOR_EXIT_STATUS = true;
    private static final boolean NO_WAIT_FOR_EXIT_STATUS = false;
    private InputStream _errorStream;
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private static final int BUFFER_SIZE = 1024;

    @Deprecated
    public void execute(String shellCommand) {
        this.execute(shellCommand, false, false);
    }

    @Deprecated
    public boolean executeAndWait(String shellCommand) {
        return this.execute(shellCommand, false, true);
    }

    @Deprecated
    public boolean executeAndWaitTimed(String shellCommand, int seconds) {
        Result result = new Result();
        CommandThread commandThread = new CommandThread(shellCommand, false, result);
        ((Thread)commandThread).start();
        try {
            if (seconds > 0) {
                commandThread.join(seconds * 1000);
                if (commandThread.isAlive()) {
                    return true;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result.commandSuccessful;
    }

    @Deprecated
    public void executeSilent(String shellCommand) throws IOException {
        Runtime.getRuntime().exec(shellCommand, null);
    }

    @Deprecated
    public boolean executeSilentAndWait(String shellCommand) {
        return this.execute(shellCommand, true, true);
    }

    public boolean executeSilentAndWait(String[] commandArray) {
        return this.execute(commandArray, true, true);
    }

    public boolean executeSilentAndWaitTimed(String shellCommand, int seconds) {
        return this.executeSAWT(shellCommand, seconds);
    }

    public boolean executeSilentAndWaitTimed(String[] commandArray, int seconds) {
        return this.executeSAWT(commandArray, seconds);
    }

    private boolean executeSAWT(Object shellCommand, int seconds) {
        String name = null;
        long begin = 0L;
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(ShellCommand.class);
        if (log.shouldDebug()) {
            if (shellCommand instanceof String) {
                name = (String)shellCommand;
            } else if (shellCommand instanceof String[]) {
                Object[] arr = (String[])shellCommand;
                name = Arrays.toString(arr);
            }
            begin = System.currentTimeMillis();
        }
        Result result = new Result();
        CommandThread commandThread = new CommandThread(shellCommand, true, result);
        ((Thread)commandThread).start();
        try {
            if (seconds > 0) {
                commandThread.join(seconds * 1000);
                if (commandThread.isAlive()) {
                    if (log.shouldDebug()) {
                        log.debug("ShellCommand gave up waiting for \"" + name + "\" after " + seconds + " seconds");
                    }
                    return true;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (log.shouldDebug()) {
            log.debug("ShellCommand returning " + result.commandSuccessful + " for \"" + name + "\" after " + (System.currentTimeMillis() - begin) + " ms");
        }
        return result.commandSuccessful;
    }

    @Deprecated
    public InputStream getErrorStream() {
        return this._errorStream;
    }

    @Deprecated
    public InputStream getInputStream() {
        return this._inputStream;
    }

    @Deprecated
    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: ShellCommand commandline");
            return;
        }
        try {
            Runtime.getRuntime().exec(args);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean execute(Object shellCommand, boolean consumeOutput, boolean waitForExitStatus) {
        block19: {
            String name = null;
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(ShellCommand.class);
            try {
                Process process;
                if (shellCommand instanceof String) {
                    name = (String)shellCommand;
                    if (log.shouldDebug()) {
                        log.debug("ShellCommand exec \"" + name + "\" consume? " + consumeOutput + " wait? " + waitForExitStatus);
                    }
                    process = Runtime.getRuntime().exec(name);
                } else if (shellCommand instanceof String[]) {
                    Object[] arr = (String[])shellCommand;
                    if (log.shouldDebug()) {
                        name = Arrays.toString(arr);
                        log.debug("ShellCommand exec \"" + name + "\" consume? " + consumeOutput + " wait? " + waitForExitStatus);
                    }
                    process = Runtime.getRuntime().exec((String[])arr);
                } else {
                    throw new ClassCastException("shell command must be a String or a String[]");
                }
                if (consumeOutput) {
                    StreamConsumer processStderrConsumer = new StreamConsumer(process.getErrorStream());
                    ((Thread)processStderrConsumer).start();
                    StreamConsumer processStdoutConsumer = new StreamConsumer(process.getInputStream());
                    ((Thread)processStdoutConsumer).start();
                } else {
                    this._errorStream = process.getErrorStream();
                    this._inputStream = process.getInputStream();
                    this._outputStream = process.getOutputStream();
                    StreamReader processStderrReader = new StreamReader(this._errorStream);
                    ((Thread)processStderrReader).start();
                    StreamWriter processStdinWriter = new StreamWriter(this._outputStream);
                    ((Thread)processStdinWriter).start();
                    StreamReader processStdoutReader = new StreamReader(this._inputStream);
                    ((Thread)processStdoutReader).start();
                }
                if (!waitForExitStatus) break block19;
                if (log.shouldDebug()) {
                    log.debug("ShellCommand waiting for \"" + name + '\"');
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    if (log.shouldWarn()) {
                        log.warn("ShellCommand exception waiting for \"" + name + '\"', e);
                    }
                    if (!consumeOutput) {
                        this.killStreams();
                    }
                    return false;
                }
                if (!consumeOutput) {
                    this.killStreams();
                }
                if (log.shouldDebug()) {
                    log.debug("ShellCommand exit value is " + process.exitValue() + " for \"" + name + '\"');
                }
                if (process.exitValue() > 0) {
                    return false;
                }
            }
            catch (IOException e) {
                if (log.shouldWarn()) {
                    log.warn("ShellCommand execute exception for \"" + name + '\"', e);
                }
                return false;
            }
        }
        return true;
    }

    private void killStreams() {
        try {
            this._errorStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._errorStream = null;
        this._inputStream = null;
        this._outputStream = null;
    }

    private static class StreamWriter
    extends I2PAppThread {
        private final BufferedWriter bufferedWriter;

        public StreamWriter(OutputStream outputStream) {
            super("ShellCommand Writer");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.bufferedWriter = new BufferedWriter(outputStreamWriter);
        }

        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    this.bufferedWriter.write(in.readLine());
                    this.bufferedWriter.write("\r\n");
                    this.bufferedWriter.flush();
                }
            }
            catch (IOException e) {
                try {
                    this.bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static class StreamReader
    extends I2PAppThread {
        private final BufferedReader bufferedReader;

        public StreamReader(InputStream inputStream) {
            super("ShellCommand Reader");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(inputStreamReader);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            buffer = new char[1024];
            try {
                block2: while (true) {
                    if ((bytesRead = this.bufferedReader.read(buffer, 0, 1024)) == -1) {
                        continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < bytesRead) ** break;
                        continue block2;
                        System.out.print(buffer[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (IOException var3_4) {
                return;
            }
        }
    }

    private static class StreamConsumer
    extends I2PAppThread {
        private final BufferedReader bufferedReader;

        public StreamConsumer(InputStream inputStream) {
            super("ShellCommand Consumer");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(inputStreamReader);
        }

        @Override
        public void run() {
            try {
                while (this.bufferedReader.readLine() != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CommandThread
    extends I2PAppThread {
        private final boolean consumeOutput;
        private final Object shellCommand;
        private final Result result;

        CommandThread(Object shellCommand2, boolean consumeOutput, Result result) {
            super("ShellCommand Executor");
            this.shellCommand = shellCommand2;
            this.consumeOutput = consumeOutput;
            this.result = result;
        }

        @Override
        public void run() {
            this.result.commandSuccessful = ShellCommand.this.execute(this.shellCommand, this.consumeOutput, true);
        }
    }

    private static class Result {
        public volatile boolean commandSuccessful;

        private Result() {
        }
    }
}

