/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLease;
import net.i2p.data.PublicKey;
import net.i2p.data.Signature;

public class MetaLeaseSet
extends LeaseSet2 {
    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void setEncryptionKey(PublicKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEncryptionKey(PublicKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._destination != null) {
            throw new IllegalStateException();
        }
        this.readHeader(in);
        this._options = DataHelper.readProperties(in, null);
        int numLeases = in.read();
        for (int i = 0; i < numLeases; ++i) {
            MetaLease lease = new MetaLease();
            ((Lease)lease).readBytes(in);
            super.addLease(lease);
        }
        int numRevokes = in.read();
        for (int i = 0; i < numRevokes; ++i) {
            DataHelper.skip(in, 32L);
        }
        SigType type = this.isOffline() ? this._transientSigningPublicKey.getType() : this._destination.getSigningPublicKey().getType();
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    protected void writeBytesWithoutSig(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this.writeHeader(out);
        if (this._options != null && !this._options.isEmpty()) {
            DataHelper.writeProperties(out, this._options);
        } else {
            DataHelper.writeLong(out, 2, 0L);
        }
        out.write(this._leases.size());
        for (Lease lease : this._leases) {
            lease.writeBytes(out);
        }
        out.write(0);
    }

    @Override
    public int size() {
        int rv = this._destination.size() + 10 + this._leases.size() * 40;
        if (this.isOffline()) {
            rv += 6 + this._transientSigningPublicKey.length() + this._offlineSignature.length();
        }
        if (this._options != null && !this._options.isEmpty()) {
            try {
                rv += DataHelper.toProperties(this._options).length;
            }
            catch (DataFormatException dfe) {
                throw new IllegalStateException("bad options", dfe);
            }
        } else {
            rv += 2;
        }
        return rv;
    }

    @Override
    public void addLease(Lease lease) {
        if (!(lease instanceof MetaLease)) {
            throw new IllegalArgumentException();
        }
        super.addLease(lease);
        this._expires = this._lastExpiration;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MetaLeaseSet)) {
            return false;
        }
        MetaLeaseSet ls = (MetaLeaseSet)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this._destination, ls.getDestination());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[MetaLeaseSet: ");
        buf.append("\n\tDestination: ").append(this._destination);
        if (this.isOffline()) {
            buf.append("\n\tTransient Key: ").append(this._transientSigningPublicKey);
            buf.append("\n\tTransient Expires: ").append(new Date(this._transientExpires));
            buf.append("\n\tOffline Signature: ").append(this._offlineSignature);
        }
        buf.append("\n\tOptions: ").append(this._options != null ? this._options.size() : 0);
        if (this._options != null && !this._options.isEmpty()) {
            for (Map.Entry<Object, Object> e : this._options.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
            }
        }
        buf.append("\n\tUnpublished? ").append(this.isUnpublished());
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        buf.append("\n\tExpires: ").append(new Date(this._expires));
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\t").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }
}

