/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

class RefreshRoutersJob
extends JobImpl {
    private final Log _log;
    private final FloodfillNetworkDatabaseFacade _facade;
    private List<Hash> _routers;
    private boolean _wasRun;
    private static final long RERUN_DELAY_MS = 2500L;
    private static final long EXPIRE = 0x6DDD00L;
    private static final long NEW_LOOP_DELAY = 2220000L;
    private static final int ENOUGH_FFS = 300;

    public RefreshRoutersJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(RefreshRoutersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Refresh Routers Job";
    }

    @Override
    public void runJob() {
        if (this._facade.isInitialized()) {
            if (this._routers == null) {
                if (this._wasRun) {
                    int ffs = this.getContext().peerManager().countPeersByCapability('f');
                    if (ffs >= 300) {
                        this.requeue(2220000L);
                        return;
                    }
                } else {
                    this._wasRun = true;
                }
                this._routers = this._facade.getFloodfillPeers();
                int ff = this._routers.size();
                Set<Hash> all = this._facade.getAllRouters();
                all.removeAll(this._routers);
                int non = all.size();
                this._routers.addAll(all);
                if (this._log.shouldLog(20)) {
                    this._log.info("To check: " + ff + " floodfills and " + non + " non-floodfills");
                }
            }
            if (this._routers.isEmpty()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Finished");
                }
                this._routers = null;
                this.requeue(2220000L);
                return;
            }
            long expire = this.getContext().clock().now() - 0x6DDD00L;
            Iterator<Hash> iter = this._routers.iterator();
            while (iter.hasNext()) {
                RouterInfo ri;
                Hash h = iter.next();
                iter.remove();
                if (h.equals(this.getContext().routerHash())) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Checking " + h);
                }
                if ((ri = this._facade.lookupRouterInfoLocally(h)) == null || ri.getPublished() >= expire) continue;
                if (this._log.shouldLog(20)) {
                    this._log.info("Refreshing " + h);
                }
                this._facade.search(h, null, null, 15000L, false);
                break;
            }
        }
        this.requeue(2500L + (long)this.getContext().random().nextInt(1024));
    }
}

