/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.RouterContext;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;

public class MessageValidator {
    private final Log _log;
    private final RouterContext _context;
    private DecayingBloomFilter _filter;
    private static final long TIME_MASK = -1024L;

    public MessageValidator(RouterContext context) {
        this._log = context.logManager().getLog(MessageValidator.class);
        this._context = context;
        long[] rates = new long[]{3600000L, 86400000L};
        context.statManager().createRateStat("router.duplicateMessageId", "Note that a duplicate messageId was received", "Router", rates);
        context.statManager().createRateStat("router.invalidMessageTime", "Note that a message outside the valid range was received", "Router", rates);
    }

    public String validateMessage(long messageId, long expiration) {
        String msg = this.validateMessage(expiration);
        if (msg != null) {
            return msg;
        }
        boolean isDuplicate = this.noteReception(messageId, expiration);
        if (isDuplicate) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message " + messageId + " duplicate", new Exception("Duplicate origin"));
            }
            this._context.statManager().addRateData("router.duplicateMessageId", 1L);
            return "duplicate";
        }
        return null;
    }

    public String validateMessage(long expiration) {
        long now = this._context.clock().now();
        if (now - 90000L >= expiration) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message expired " + (now - expiration) + "ms ago");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration);
            return "expired " + (now - expiration) + "ms ago";
        }
        if (now + 240000L < expiration) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message expiring too far in the future (" + (expiration - now) + "ms)");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration);
            return "expire too far in the future (" + (expiration - now) + "ms)";
        }
        return null;
    }

    private boolean noteReception(long messageId, long messageExpiration) {
        long val = messageId;
        boolean dup = this._filter.add(val ^= messageExpiration & 0xFFFFFFFFFFFFFC00L);
        if (dup && this._log.shouldLog(30)) {
            this._log.warn("Duplicate with " + this._filter.getCurrentDuplicateCount() + " other dups, " + this._filter.getInsertedCount() + " other entries, and a false positive rate of " + this._filter.getFalsePositiveRate());
        }
        return dup;
    }

    public synchronized void startup() {
        this._filter = new DecayingHashSet(this._context, 120000, 8, "RouterMV");
    }

    synchronized void shutdown() {
        this._filter.stopDecaying();
    }
}

