/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.https.HttpsRequestMessage;
import de.rub.nds.tlsattacker.core.https.HttpsResponseMessage;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateStatusMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SupplementalDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownHandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ReceiveMessageHelper;
import de.rub.nds.tlsattacker.core.workflow.action.executor.SendMessageHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForwardMessagesAction
extends TlsAction
implements ReceivingAction,
SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElement(name="from")
    protected String receiveFromAlias = null;
    @XmlElement(name="to")
    protected String forwardToAlias = null;
    @XmlTransient
    protected Boolean executedAsPlanned = null;
    @XmlTransient
    protected Boolean withPrepare = false;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=ProtocolMessage.class, name="ProtocolMessage"), @XmlElement(type=CertificateMessage.class, name="Certificate"), @XmlElement(type=CertificateVerifyMessage.class, name="CertificateVerify"), @XmlElement(type=CertificateRequestMessage.class, name="CertificateRequest"), @XmlElement(type=CertificateStatusMessage.class, name="CertificateStatus"), @XmlElement(type=ClientHelloMessage.class, name="ClientHello"), @XmlElement(type=HelloVerifyRequestMessage.class, name="HelloVerifyRequest"), @XmlElement(type=DHClientKeyExchangeMessage.class, name="DHClientKeyExchange"), @XmlElement(type=DHEServerKeyExchangeMessage.class, name="DHEServerKeyExchange"), @XmlElement(type=ECDHClientKeyExchangeMessage.class, name="ECDHClientKeyExchange"), @XmlElement(type=ECDHEServerKeyExchangeMessage.class, name="ECDHEServerKeyExchange"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PSKClientKeyExchange"), @XmlElement(type=PWDServerKeyExchangeMessage.class, name="PWDServerKeyExchange"), @XmlElement(type=PWDClientKeyExchangeMessage.class, name="PWDClientKeyExchange"), @XmlElement(type=FinishedMessage.class, name="Finished"), @XmlElement(type=RSAClientKeyExchangeMessage.class, name="RSAClientKeyExchange"), @XmlElement(type=GOSTClientKeyExchangeMessage.class, name="GOSTClientKeyExchange"), @XmlElement(type=ServerHelloDoneMessage.class, name="ServerHelloDone"), @XmlElement(type=ServerHelloMessage.class, name="ServerHello"), @XmlElement(type=AlertMessage.class, name="Alert"), @XmlElement(type=NewSessionTicketMessage.class, name="NewSessionTicket"), @XmlElement(type=ApplicationMessage.class, name="Application"), @XmlElement(type=ChangeCipherSpecMessage.class, name="ChangeCipherSpec"), @XmlElement(type=SSL2ClientHelloMessage.class, name="SSL2ClientHello"), @XmlElement(type=SSL2ServerHelloMessage.class, name="SSL2ServerHello"), @XmlElement(type=SSL2ClientMasterKeyMessage.class, name="SSL2ClientMasterKey"), @XmlElement(type=SSL2ServerVerifyMessage.class, name="SSL2ServerVerify"), @XmlElement(type=UnknownMessage.class, name="UnknownMessage"), @XmlElement(type=UnknownHandshakeMessage.class, name="UnknownHandshakeMessage"), @XmlElement(type=HelloRequestMessage.class, name="HelloRequest"), @XmlElement(type=HeartbeatMessage.class, name="Heartbeat"), @XmlElement(type=SupplementalDataMessage.class, name="SupplementalDataMessage"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensionMessage"), @XmlElement(type=HttpsRequestMessage.class, name="HttpsRequest"), @XmlElement(type=HttpsResponseMessage.class, name="HttpsResponse"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PskClientKeyExchange"), @XmlElement(type=PskDhClientKeyExchangeMessage.class, name="PskDhClientKeyExchange"), @XmlElement(type=PskDheServerKeyExchangeMessage.class, name="PskDheServerKeyExchange"), @XmlElement(type=PskEcDhClientKeyExchangeMessage.class, name="PskEcDhClientKeyExchange"), @XmlElement(type=PskEcDheServerKeyExchangeMessage.class, name="PskEcDheServerKeyExchange"), @XmlElement(type=PskRsaClientKeyExchangeMessage.class, name="PskRsaClientKeyExchange"), @XmlElement(type=PskServerKeyExchangeMessage.class, name="PskServerKeyExchange"), @XmlElement(type=SrpServerKeyExchangeMessage.class, name="SrpServerKeyExchange"), @XmlElement(type=SrpClientKeyExchangeMessage.class, name="SrpClientKeyExchange"), @XmlElement(type=EndOfEarlyDataMessage.class, name="EndOfEarlyData"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensions"), @XmlElement(type=HelloRetryRequestMessage.class, name="HelloRetryRequest")})
    protected List<ProtocolMessage> receivedMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=Record.class, name="Record"), @XmlElement(type=BlobRecord.class, name="BlobRecord")})
    protected List<AbstractRecord> receivedRecords;
    @XmlElementWrapper
    @HoldsModifiableVariable
    @XmlElements(value={@XmlElement(type=ProtocolMessage.class, name="ProtocolMessage"), @XmlElement(type=CertificateMessage.class, name="Certificate"), @XmlElement(type=CertificateVerifyMessage.class, name="CertificateVerify"), @XmlElement(type=CertificateRequestMessage.class, name="CertificateRequest"), @XmlElement(type=ClientHelloMessage.class, name="ClientHello"), @XmlElement(type=HelloVerifyRequestMessage.class, name="HelloVerifyRequest"), @XmlElement(type=DHClientKeyExchangeMessage.class, name="DHClientKeyExchange"), @XmlElement(type=DHEServerKeyExchangeMessage.class, name="DHEServerKeyExchange"), @XmlElement(type=ECDHClientKeyExchangeMessage.class, name="ECDHClientKeyExchange"), @XmlElement(type=ECDHEServerKeyExchangeMessage.class, name="ECDHEServerKeyExchange"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PSKClientKeyExchange"), @XmlElement(type=FinishedMessage.class, name="Finished"), @XmlElement(type=RSAClientKeyExchangeMessage.class, name="RSAClientKeyExchange"), @XmlElement(type=GOSTClientKeyExchangeMessage.class, name="GOSTClientKeyExchange"), @XmlElement(type=ServerHelloDoneMessage.class, name="ServerHelloDone"), @XmlElement(type=ServerHelloMessage.class, name="ServerHello"), @XmlElement(type=AlertMessage.class, name="Alert"), @XmlElement(type=NewSessionTicketMessage.class, name="NewSessionTicket"), @XmlElement(type=ApplicationMessage.class, name="Application"), @XmlElement(type=ChangeCipherSpecMessage.class, name="ChangeCipherSpec"), @XmlElement(type=SSL2ClientHelloMessage.class, name="SSL2ClientHello"), @XmlElement(type=SSL2ServerHelloMessage.class, name="SSL2ServerHello"), @XmlElement(type=SSL2ClientMasterKeyMessage.class, name="SSL2ClientMasterKey"), @XmlElement(type=SSL2ServerVerifyMessage.class, name="SSL2ServerVerify"), @XmlElement(type=UnknownMessage.class, name="UnknownMessage"), @XmlElement(type=UnknownHandshakeMessage.class, name="UnknownHandshakeMessage"), @XmlElement(type=HelloRequestMessage.class, name="HelloRequest"), @XmlElement(type=HeartbeatMessage.class, name="Heartbeat"), @XmlElement(type=SupplementalDataMessage.class, name="SupplementalDataMessage"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensionMessage"), @XmlElement(type=HttpsRequestMessage.class, name="HttpsRequest"), @XmlElement(type=HttpsResponseMessage.class, name="HttpsResponse"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PskClientKeyExchange"), @XmlElement(type=PskDhClientKeyExchangeMessage.class, name="PskDhClientKeyExchange"), @XmlElement(type=PskDheServerKeyExchangeMessage.class, name="PskDheServerKeyExchange"), @XmlElement(type=PskEcDhClientKeyExchangeMessage.class, name="PskEcDhClientKeyExchange"), @XmlElement(type=PskEcDheServerKeyExchangeMessage.class, name="PskEcDheServerKeyExchange"), @XmlElement(type=PskRsaClientKeyExchangeMessage.class, name="PskRsaClientKeyExchange"), @XmlElement(type=PskServerKeyExchangeMessage.class, name="PskServerKeyExchange"), @XmlElement(type=SrpServerKeyExchangeMessage.class, name="SrpServerKeyExchange"), @XmlElement(type=SrpClientKeyExchangeMessage.class, name="SrpClientKeyExchange"), @XmlElement(type=EndOfEarlyDataMessage.class, name="EndOfEarlyData"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensions"), @XmlElement(type=HelloRetryRequestMessage.class, name="HelloRetryRequest")})
    protected List<ProtocolMessage> messages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=Record.class, name="Record"), @XmlElement(type=BlobRecord.class, name="BlobRecord")})
    protected List<AbstractRecord> records;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=ProtocolMessage.class, name="ProtocolMessage"), @XmlElement(type=CertificateMessage.class, name="Certificate"), @XmlElement(type=CertificateVerifyMessage.class, name="CertificateVerify"), @XmlElement(type=CertificateRequestMessage.class, name="CertificateRequest"), @XmlElement(type=ClientHelloMessage.class, name="ClientHello"), @XmlElement(type=HelloVerifyRequestMessage.class, name="HelloVerifyRequest"), @XmlElement(type=DHClientKeyExchangeMessage.class, name="DHClientKeyExchange"), @XmlElement(type=DHEServerKeyExchangeMessage.class, name="DHEServerKeyExchange"), @XmlElement(type=ECDHClientKeyExchangeMessage.class, name="ECDHClientKeyExchange"), @XmlElement(type=ECDHEServerKeyExchangeMessage.class, name="ECDHEServerKeyExchange"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PSKClientKeyExchange"), @XmlElement(type=FinishedMessage.class, name="Finished"), @XmlElement(type=RSAClientKeyExchangeMessage.class, name="RSAClientKeyExchange"), @XmlElement(type=GOSTClientKeyExchangeMessage.class, name="GOSTClientKeyExchange"), @XmlElement(type=ServerHelloDoneMessage.class, name="ServerHelloDone"), @XmlElement(type=ServerHelloMessage.class, name="ServerHello"), @XmlElement(type=AlertMessage.class, name="Alert"), @XmlElement(type=NewSessionTicketMessage.class, name="NewSessionTicket"), @XmlElement(type=ApplicationMessage.class, name="Application"), @XmlElement(type=ChangeCipherSpecMessage.class, name="ChangeCipherSpec"), @XmlElement(type=SSL2ClientHelloMessage.class, name="SSL2ClientHello"), @XmlElement(type=SSL2ServerHelloMessage.class, name="SSL2ServerHello"), @XmlElement(type=SSL2ClientMasterKeyMessage.class, name="SSL2ClientMasterKey"), @XmlElement(type=SSL2ServerVerifyMessage.class, name="SSL2ServerVerify"), @XmlElement(type=UnknownMessage.class, name="UnknownMessage"), @XmlElement(type=UnknownHandshakeMessage.class, name="UnknownHandshakeMessage"), @XmlElement(type=HelloRequestMessage.class, name="HelloRequest"), @XmlElement(type=HeartbeatMessage.class, name="Heartbeat"), @XmlElement(type=SupplementalDataMessage.class, name="SupplementalDataMessage"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensionMessage"), @XmlElement(type=HttpsRequestMessage.class, name="HttpsRequest"), @XmlElement(type=HttpsResponseMessage.class, name="HttpsResponse"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PskClientKeyExchange"), @XmlElement(type=PskDhClientKeyExchangeMessage.class, name="PskDhClientKeyExchange"), @XmlElement(type=PskDheServerKeyExchangeMessage.class, name="PskDheServerKeyExchange"), @XmlElement(type=PskEcDhClientKeyExchangeMessage.class, name="PskEcDhClientKeyExchange"), @XmlElement(type=PskEcDheServerKeyExchangeMessage.class, name="PskEcDheServerKeyExchange"), @XmlElement(type=PskRsaClientKeyExchangeMessage.class, name="PskRsaClientKeyExchange"), @XmlElement(type=PskServerKeyExchangeMessage.class, name="PskServerKeyExchange"), @XmlElement(type=SrpServerKeyExchangeMessage.class, name="SrpServerKeyExchange"), @XmlElement(type=SrpClientKeyExchangeMessage.class, name="SrpClientKeyExchange"), @XmlElement(type=EndOfEarlyDataMessage.class, name="EndOfEarlyData"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensions"), @XmlElement(type=HelloRetryRequestMessage.class, name="HelloRetryRequest")})
    protected List<ProtocolMessage> sendMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=Record.class, name="Record"), @XmlElement(type=BlobRecord.class, name="BlobRecord")})
    protected List<AbstractRecord> sendRecords;
    @XmlTransient
    protected ReceiveMessageHelper receiveMessageHelper;
    @XmlTransient
    protected SendMessageHelper sendMessageHelper;

    public ForwardMessagesAction() {
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public ForwardMessagesAction(String receiveFromAlias, String forwardToAlias) {
        this(receiveFromAlias, forwardToAlias, new ReceiveMessageHelper());
    }

    protected ForwardMessagesAction(String receiveFromAlias, String forwardToAlias, ReceiveMessageHelper receiveMessageHelper) {
        this.receiveFromAlias = receiveFromAlias;
        this.forwardToAlias = forwardToAlias;
        this.receiveMessageHelper = receiveMessageHelper;
        this.sendMessageHelper = new SendMessageHelper();
    }

    public ForwardMessagesAction(String receiveFromAlias, String forwardToAlias, List<ProtocolMessage> messages) {
        this.messages = messages;
        this.receiveFromAlias = receiveFromAlias;
        this.forwardToAlias = forwardToAlias;
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public ForwardMessagesAction(String receiveFromAlias, String forwardToAlias, ProtocolMessage ... messages) {
        this(receiveFromAlias, forwardToAlias, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public void setReceiveFromAlias(String receiveFromAlias) {
        this.receiveFromAlias = receiveFromAlias;
    }

    public void setForwardToAlias(String forwardToAlias) {
        this.forwardToAlias = forwardToAlias;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.assertAliasesSetProperly();
        TlsContext receiveFromCtx = state.getTlsContext(this.receiveFromAlias);
        TlsContext forwardToCtx = state.getTlsContext(this.forwardToAlias);
        this.receiveMessages(receiveFromCtx);
        this.applyMessages(forwardToCtx);
        this.forwardMessages(forwardToCtx);
    }

    void receiveMessages(TlsContext receiveFromCtx) {
        LOGGER.debug("Receiving Messages...");
        MessageActionResult result = this.receiveMessageHelper.receiveMessages(this.messages, receiveFromCtx);
        this.receivedRecords = result.getRecordList();
        this.receivedMessages = result.getMessageList();
        String expected = this.getReadableString(this.receivedMessages);
        LOGGER.debug("Receive Expected (" + this.receiveFromAlias + "): " + expected);
        String received = this.getReadableString(this.receivedMessages);
        LOGGER.info("Received Messages (" + this.receiveFromAlias + "): " + received);
        this.executedAsPlanned = this.checkMessageListsEquals(this.messages, this.receivedMessages);
    }

    private void applyMessages(TlsContext ctx) {
        for (ProtocolMessage msg : this.receivedMessages) {
            LOGGER.debug("Applying " + msg.toCompactString() + " to forward context " + ctx);
            ProtocolMessageHandler h = msg.getHandler(ctx);
            h.adjustTLSContext(msg);
        }
    }

    private void forwardMessages(TlsContext forwardToCtx) {
        LOGGER.info("Forwarding messages (" + this.forwardToAlias + "): " + this.getReadableString(this.messages));
        try {
            MessageActionResult result = this.sendMessageHelper.sendMessages(this.receivedMessages, this.receivedRecords, forwardToCtx, this.withPrepare);
            this.sendMessages = result.getMessageList();
            this.sendRecords = result.getRecordList();
            if (this.executedAsPlanned.booleanValue()) {
                this.executedAsPlanned = this.checkMessageListsEquals(this.sendMessages, this.messages);
            }
            this.setExecuted(true);
        }
        catch (IOException E) {
            LOGGER.debug((Object)E);
            this.executedAsPlanned = false;
            this.setExecuted(false);
        }
    }

    public String getReceiveFromAlias() {
        return this.receiveFromAlias;
    }

    public String getForwardToAlias() {
        return this.forwardToAlias;
    }

    private boolean checkMessageListsEquals(List<ProtocolMessage> expectedMessages, List<ProtocolMessage> actualMessages) {
        boolean actualEmpty = true;
        boolean expectedEmpty = true;
        if (actualMessages != null && !actualMessages.isEmpty()) {
            actualEmpty = false;
        }
        if (expectedMessages != null && !expectedMessages.isEmpty()) {
            expectedEmpty = false;
        }
        if (actualEmpty == expectedEmpty) {
            return true;
        }
        if (actualEmpty != expectedEmpty) {
            return false;
        }
        if (actualMessages.size() != expectedMessages.size()) {
            return false;
        }
        for (int i = 0; i < actualMessages.size(); ++i) {
            if (actualMessages.get(i).getClass().equals(expectedMessages.get(i).getClass())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.executedAsPlanned;
    }

    @Override
    public void reset() {
        this.receivedMessages = null;
        this.receivedRecords = null;
        this.sendMessages = null;
        this.sendRecords = null;
        this.executedAsPlanned = false;
        this.setExecuted(null);
    }

    @Override
    public List<ProtocolMessage> getReceivedMessages() {
        return this.receivedMessages;
    }

    @Override
    public List<AbstractRecord> getReceivedRecords() {
        return this.receivedRecords;
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.sendMessages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.sendRecords;
    }

    public List<ProtocolMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ProtocolMessage> messages) {
        this.messages = messages;
    }

    public void setMessages(ProtocolMessage ... messages) {
        this.messages = new ArrayList<ProtocolMessage>(Arrays.asList(messages));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.receiveFromAlias);
        hash = 89 * hash + Objects.hashCode(this.forwardToAlias);
        hash = 89 * hash + Objects.hashCode(this.executedAsPlanned);
        hash = 89 * hash + Objects.hashCode(this.receivedMessages);
        hash = 89 * hash + Objects.hashCode(this.receivedRecords);
        hash = 89 * hash + Objects.hashCode(this.sendMessages);
        hash = 89 * hash + Objects.hashCode(this.sendRecords);
        hash = 89 * hash + Objects.hashCode(this.messages);
        hash = 89 * hash + Objects.hashCode(this.records);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForwardMessagesAction other = (ForwardMessagesAction)obj;
        if (!Objects.equals(this.receiveFromAlias, other.receiveFromAlias)) {
            return false;
        }
        if (!Objects.equals(this.forwardToAlias, other.forwardToAlias)) {
            return false;
        }
        if (!Objects.equals(this.executedAsPlanned, other.executedAsPlanned)) {
            return false;
        }
        if (!this.checkMessageListsEquals(this.receivedMessages, other.receivedMessages)) {
            return false;
        }
        if (!Objects.equals(this.receivedRecords, other.receivedRecords)) {
            return false;
        }
        if (!this.checkMessageListsEquals(this.sendMessages, other.sendMessages)) {
            return false;
        }
        if (!Objects.equals(this.sendRecords, other.sendRecords)) {
            return false;
        }
        if (!this.checkMessageListsEquals(this.messages, other.messages)) {
            return false;
        }
        return Objects.equals(this.records, other.records);
    }

    @Override
    public Set<String> getAllAliases() {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        aliases.add(this.forwardToAlias);
        aliases.add(this.receiveFromAlias);
        return aliases;
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
        if (this.receiveFromAlias == null || this.receiveFromAlias.isEmpty()) {
            throw new WorkflowExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty receive alias (if using XML: add <from/>)");
        }
        if (this.forwardToAlias == null || this.forwardToAlias.isEmpty()) {
            throw new WorkflowExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty forward alis (if using XML: add <to/>)");
        }
    }

    public String getReadableString(List<ProtocolMessage> messages) {
        return this.getReadableString(messages, false);
    }

    public String getReadableString(List<ProtocolMessage> messages, Boolean verbose) {
        StringBuilder builder = new StringBuilder();
        if (messages == null) {
            return builder.toString();
        }
        for (ProtocolMessage message : messages) {
            if (verbose.booleanValue()) {
                builder.append(message.toString());
            } else {
                builder.append(message.toCompactString());
            }
            if (!message.isRequired()) {
                builder.append("*");
            }
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public void normalize() {
        super.normalize();
        this.initEmptyLists();
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        super.normalize(defaultAction);
        this.initEmptyLists();
    }

    @Override
    public void filter() {
        super.filter();
        this.stripEmptyLists();
    }

    @Override
    public void filter(TlsAction defaultAction) {
        super.filter(defaultAction);
        this.stripEmptyLists();
    }

    private void stripEmptyLists() {
        if (this.messages == null || this.messages.isEmpty()) {
            this.messages = null;
        }
        if (this.records == null || this.records.isEmpty()) {
            this.records = null;
        }
        if (this.receivedMessages == null || this.receivedMessages.isEmpty()) {
            this.receivedMessages = null;
        }
        if (this.receivedRecords == null || this.receivedRecords.isEmpty()) {
            this.receivedRecords = null;
        }
        if (this.sendMessages == null || this.sendMessages.isEmpty()) {
            this.sendMessages = null;
        }
        if (this.sendRecords == null || this.sendRecords.isEmpty()) {
            this.sendRecords = null;
        }
    }

    private void initEmptyLists() {
        if (this.messages == null) {
            this.messages = new ArrayList<ProtocolMessage>();
        }
        if (this.records == null) {
            this.records = new ArrayList<AbstractRecord>();
        }
        if (this.receivedMessages == null) {
            this.receivedMessages = new ArrayList<ProtocolMessage>();
        }
        if (this.receivedRecords == null) {
            this.receivedRecords = new ArrayList<AbstractRecord>();
        }
        if (this.sendMessages == null) {
            this.sendMessages = new ArrayList<ProtocolMessage>();
        }
        if (this.sendRecords == null) {
            this.sendRecords = new ArrayList<AbstractRecord>();
        }
    }
}

