/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenegotiationInfoExtensionParser
extends ExtensionParser<RenegotiationInfoExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RenegotiationInfoExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(RenegotiationInfoExtensionMessage msg) {
        msg.setRenegotiationInfoLength(this.parseIntField(1));
        if ((Integer)msg.getRenegotiationInfoLength().getValue() > 255) {
            LOGGER.warn("The renegotiation info length shouldn't exceed 1 byte as defined in RFC 5246. Length was " + msg.getExtensionLength().getValue());
        }
        msg.setRenegotiationInfo(this.parseByteArrayField((Integer)msg.getRenegotiationInfoLength().getValue()));
        LOGGER.debug("The RenegotiationInfoExtensionParser parsed the value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getRenegotiationInfo()));
    }

    @Override
    protected RenegotiationInfoExtensionMessage createExtensionMessage() {
        return new RenegotiationInfoExtensionMessage();
    }
}

