/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.SupplementalDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.supplementaldata.SupplementalDataEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import de.rub.nds.tlsattacker.core.protocol.parser.supplementaldata.SupplementalDataEntryParser;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupplementalDataParser
extends HandshakeMessageParser<SupplementalDataMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupplementalDataParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.SUPPLEMENTAL_DATA, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(SupplementalDataMessage msg) {
        LOGGER.debug("Parsing SupplementalDataMessage");
        this.parseSupplementalDataLength(msg);
        this.parseSupplementalDataBytes(msg);
        this.parseSupplementalDataEntries(msg);
    }

    @Override
    protected SupplementalDataMessage createHandshakeMessage() {
        return new SupplementalDataMessage();
    }

    private void parseSupplementalDataLength(SupplementalDataMessage msg) {
        msg.setSupplementalDataLength(this.parseIntField(3));
        LOGGER.debug("SupplementalDataLength: " + msg.getSupplementalDataLength().getValue());
    }

    private void parseSupplementalDataBytes(SupplementalDataMessage msg) {
        msg.setSupplementalDataBytes(this.parseByteArrayField((Integer)msg.getSupplementalDataLength().getValue()));
        LOGGER.debug("SupplementalDataBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSupplementalDataBytes().getValue())));
    }

    private void parseSupplementalDataEntries(SupplementalDataMessage msg) {
        int pointer = 0;
        LinkedList<SupplementalDataEntry> entryList = new LinkedList<SupplementalDataEntry>();
        while (pointer < (Integer)msg.getSupplementalDataLength().getValue()) {
            SupplementalDataEntryParser parser = new SupplementalDataEntryParser(pointer, (byte[])msg.getSupplementalDataBytes().getValue());
            entryList.add(parser.parse());
            if (pointer == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing SupplementalDataEntries");
            }
            pointer = parser.getPointer();
        }
        msg.setEntries(entryList);
    }
}

