/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.HeartbeatMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class HeartbeatMessage
extends ProtocolMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    ModifiableByte heartbeatMessageType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    ModifiableInteger payloadLength;
    @ModifiableVariableProperty
    ModifiableByteArray payload;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PADDING)
    ModifiableByteArray padding;

    public HeartbeatMessage() {
        this.protocolMessageType = ProtocolMessageType.HEARTBEAT;
    }

    public HeartbeatMessage(Config tlsConfig) {
        this.protocolMessageType = ProtocolMessageType.HEARTBEAT;
    }

    public ModifiableByte getHeartbeatMessageType() {
        return this.heartbeatMessageType;
    }

    public void setHeartbeatMessageType(ModifiableByte heartbeatMessageType) {
        this.heartbeatMessageType = heartbeatMessageType;
    }

    public void setHeartbeatMessageType(byte heartbeatMessageType) {
        this.heartbeatMessageType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.heartbeatMessageType, (Byte)heartbeatMessageType);
    }

    public ModifiableInteger getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(ModifiableInteger payloadLength) {
        this.payloadLength = payloadLength;
    }

    public void setPayloadLength(int payloadLength) {
        this.payloadLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.payloadLength, (Integer)payloadLength);
    }

    public ModifiableByteArray getPayload() {
        return this.payload;
    }

    public void setPayload(ModifiableByteArray payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.payload, (byte[])payload);
    }

    public ModifiableByteArray getPadding() {
        return this.padding;
    }

    public void setPadding(ModifiableByteArray padding) {
        this.padding = padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.padding, (byte[])padding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HeartbeatMessage:");
        sb.append("\n  Type: ");
        if (this.heartbeatMessageType != null && this.heartbeatMessageType.getValue() != null) {
            sb.append((Object)HeartbeatMessageType.getHeartbeatMessageType((Byte)this.heartbeatMessageType.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Payload Length: ");
        if (this.payloadLength != null && this.payloadLength.getValue() != null) {
            sb.append(this.payloadLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Payload: ");
        if (this.payload != null && this.payload.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.payload.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Padding: ");
        if (this.padding != null && this.padding.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.padding.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        return "Heartbeat";
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new HeartbeatMessageHandler(context);
    }
}

