/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.connectivity.ConnectivityChecker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.TLSDelegateConfig;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Attacker<AttConfig extends AttackConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected AttConfig config;
    private final Config baseConfig;

    public Attacker(AttConfig config, Config baseConfig) {
        this.config = config;
        this.baseConfig = baseConfig;
    }

    public void attack() {
        LOGGER.debug("Attacking with: " + this.getClass().getSimpleName());
        if (!((AttackConfig)this.config).isSkipConnectionCheck() && !this.canConnect().booleanValue()) {
            ConsoleLogger.CONSOLE.warn("Cannot reach Server. Is the server online?");
            return;
        }
        this.executeAttack();
    }

    public Boolean checkVulnerability() {
        LOGGER.debug("Checking: " + this.getClass().getSimpleName());
        if (!((AttackConfig)this.config).isSkipConnectionCheck()) {
            if (!this.canConnect().booleanValue()) {
                ConsoleLogger.CONSOLE.warn("Cannot reach Server. Is the server online?");
                return null;
            }
            LOGGER.debug("Can connect to server. Running vulnerability scan");
        }
        return this.isVulnerable();
    }

    protected abstract void executeAttack();

    protected abstract Boolean isVulnerable();

    public AttConfig getConfig() {
        return this.config;
    }

    public Config getTlsConfig() {
        if (!((TLSDelegateConfig)this.config).hasDifferentConfig() && this.baseConfig == null) {
            return ((TLSDelegateConfig)this.config).createConfig();
        }
        return ((TLSDelegateConfig)this.config).createConfig(this.baseConfig);
    }

    public Config getBaseConfig() {
        return this.baseConfig.createCopy();
    }

    protected Boolean canConnect() {
        Config tlsConfig = ((TLSDelegateConfig)this.config).createConfig();
        ConnectivityChecker checker = new ConnectivityChecker(tlsConfig.getDefaultClientConnection());
        return checker.isConnectable();
    }
}

