/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.Server;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.extension.option.DatabaseParam;

public class ParosDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = LogManager.getLogger(ParosDatabaseServer.class);
    String mUrl;
    String mUser = "sa";
    String mPassword = "";
    Server mServer = null;
    Connection mConn = null;
    private final DatabaseParam databaseOptions;

    ParosDatabaseServer(String dbname, DatabaseParam databaseOptions) throws ClassNotFoundException, Exception {
        if (databaseOptions == null) {
            throw new IllegalArgumentException("Parameter databaseOptions must not be null.");
        }
        this.databaseOptions = databaseOptions;
        this.start(dbname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(String dbname) throws ClassNotFoundException, Exception {
        dbname = dbname.replaceAll("\\\\", "/");
        boolean doCompact = false;
        File propsFile = new File(dbname + ".properties");
        if (propsFile.exists()) {
            Properties dbProps = new Properties();
            FileInputStream propsStream = null;
            try {
                propsStream = new FileInputStream(propsFile);
                dbProps.load(propsStream);
            }
            finally {
                block18: {
                    try {
                        if (propsStream != null) {
                            ((InputStream)propsStream).close();
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block18;
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            String version = (String)dbProps.get("version");
            if (version.charAt(0) < '2') {
                doCompact = true;
            }
        }
        this.mUrl = "jdbc:hsqldb:file:" + dbname;
        Class.forName("org.hsqldb.jdbcDriver");
        this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        if (doCompact) {
            this.shutdown(true);
            this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        }
        String query = "SET FILES LOG " + (this.databaseOptions.isRecoveryLogEnabled() ? "TRUE" : "FALSE");
        try (Statement stmt = this.getSingletonConnection().createStatement();){
            stmt.executeUpdate(query);
        }
    }

    void shutdown(boolean compact) throws SQLException {
        Connection conn = this.getSingletonConnection();
        CallableStatement psCompact = null;
        psCompact = compact ? conn.prepareCall("SHUTDOWN COMPACT") : conn.prepareCall("SHUTDOWN");
        psCompact.execute();
        psCompact.close();
        this.mConn.close();
        this.mConn = null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection conn = null;
        for (int i = 0; i < 5; ++i) {
            try {
                conn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                return conn;
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (i == 4) {
                    throw e;
                }
                logger.warn("Recovering " + i + " times.");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(e2.getMessage(), (Throwable)e2);
                }
                continue;
            }
        }
        return conn;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.mConn == null) {
            this.mConn = this.getNewConnection();
        }
        return this.mConn;
    }
}

