/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.StatementNode;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;

public class DeclarationNode
extends StatementNode {
    private ExpressionNode expressionNode;
    protected String name;
    protected Class<?> declarationType;

    public void setExpressionNode(ExpressionNode expressionNode) {
        this.expressionNode = expressionNode;
    }

    public ExpressionNode getExpressionNode() {
        return this.expressionNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeclarationType(Class<?> declarationType) {
        this.declarationType = declarationType;
    }

    public Class<?> getDeclarationType() {
        return this.declarationType;
    }

    public String getDeclarationCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.declarationType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitDeclaration(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.expressionNode != null) {
            this.expressionNode.visit(irTreeVisitor, scope);
        }
    }

    public DeclarationNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable(this.declarationType, this.name);
        if (this.expressionNode == null) {
            Class<?> sort = variable.getType();
            if (sort == Void.TYPE || sort == Boolean.TYPE || sort == Byte.TYPE || sort == Short.TYPE || sort == Character.TYPE || sort == Integer.TYPE) {
                methodWriter.push(0);
            } else if (sort == Long.TYPE) {
                methodWriter.push(0L);
            } else if (sort == Float.TYPE) {
                methodWriter.push(0.0f);
            } else if (sort == Double.TYPE) {
                methodWriter.push(0.0);
            } else {
                methodWriter.visitInsn(1);
            }
        } else {
            this.expressionNode.write(classWriter, methodWriter, writeScope);
        }
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
    }
}

